{ *****************************************************************************
  Implementing COM Component Callbacks in Delphi
  Code written for Delphi Informant publication

  Comments, questions, suggestions?
  Binh Ly, Systems Analyst (bly@brickhouse.com)
  Brickhouse Data Systems (http://www.brickhouse.com)
  *****************************************************************************
}
unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TfrmMain = class(TForm)
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses
  ChatConnection
  ;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  mr : integer;
begin
  { ensure we ask user if there are still active connections before terminating }  
  if (ChatConnections > 0) then
  begin
    mr := MessageDlg (
      Format (
        'Chat server has %d active connection(s). Terminating this application will cause connected clients to fail.'#13 +
        'Do you want to terminate anyway?',
        [ChatConnections]
      ), mtConfirmation, [mbYes, mbNo], 0
    );

    CanClose := (mr = mrYes);
  end;  { if }
end;

end.
