unit ChatServer_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ ChatServer Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_ChatServer: TGUID = '{624DDEA1-70F1-11D1-B877-0000B4552A26}';

const

{ Component class GUIDs }
  Class_ChatConnection: TGUID = '{624DDEA3-70F1-11D1-B877-0000B4552A26}';
  Class_ChatChannel: TGUID = '{8FDCD6B6-742C-11D1-B87E-0000B4552A26}';

type

{ Forward declarations: Interfaces }
  IChatConnection = interface;
  IChatConnectionDisp = dispinterface;
  IChatChannel = interface;
  IChatChannelDisp = dispinterface;
  IChatEvent = interface;
  IChatEventDisp = dispinterface;

{ Forward declarations: CoClasses }
  ChatConnection = IChatConnection;
  ChatChannel = IChatChannel;

  IChatConnection = interface(IDispatch)
    ['{624DDEA2-70F1-11D1-B877-0000B4552A26}']
    function Get_ChatChannel: IChatChannel; safecall;
    procedure BroadcastMessage(const UserName, Message: WideString); safecall;
    property ChatChannel: IChatChannel read Get_ChatChannel;
  end;

{ DispInterface declaration for Dual Interface IChatConnection }

  IChatConnectionDisp = dispinterface
    ['{624DDEA2-70F1-11D1-B877-0000B4552A26}']
    property ChatChannel: IChatChannel readonly dispid 1;
    procedure BroadcastMessage(const UserName, Message: WideString); dispid 2;
  end;

  IChatChannel = interface(IDispatch)
    ['{ADF8F1E0-72A0-11D1-B87B-0000B4552A26}']
    function ConnectUser(const Callback: IChatEvent; var UserId: Integer): WordBool; safecall;
    function DisconnectUser(UserId: Integer): WordBool; safecall;
    procedure BroadcastMessage(const UserName, Message: WideString); safecall;
  end;

{ DispInterface declaration for Dual Interface IChatChannel }

  IChatChannelDisp = dispinterface
    ['{ADF8F1E0-72A0-11D1-B87B-0000B4552A26}']
    function ConnectUser(const Callback: IChatEvent; var UserId: Integer): WordBool; dispid 1;
    function DisconnectUser(UserId: Integer): WordBool; dispid 2;
    procedure BroadcastMessage(const UserName, Message: WideString); dispid 3;
  end;

  IChatEvent = interface(IDispatch)
    ['{2A611DD1-743E-11D1-B87F-0000B4552A26}']
    procedure GotMessage(const UserName, Message: WideString); safecall;
  end;

{ DispInterface declaration for Dual Interface IChatEvent }

  IChatEventDisp = dispinterface
    ['{2A611DD1-743E-11D1-B87F-0000B4552A26}']
    procedure GotMessage(const UserName, Message: WideString); dispid 1;
  end;

{ ChatConnection }

  CoChatConnection = class
    class function Create: IChatConnection;
    class function CreateRemote(const MachineName: string): IChatConnection;
  end;

{ ChatChannel }

  CoChatChannel = class
    class function Create: IChatChannel;
    class function CreateRemote(const MachineName: string): IChatChannel;
  end;



implementation

uses ComObj;

class function CoChatConnection.Create: IChatConnection;
begin
  Result := CreateComObject(Class_ChatConnection) as IChatConnection;
end;

class function CoChatConnection.CreateRemote(const MachineName: string): IChatConnection;
begin
  Result := CreateRemoteComObject(MachineName, Class_ChatConnection) as IChatConnection;
end;

class function CoChatChannel.Create: IChatChannel;
begin
  Result := CreateComObject(Class_ChatChannel) as IChatChannel;
end;

class function CoChatChannel.CreateRemote(const MachineName: string): IChatChannel;
begin
  Result := CreateRemoteComObject(MachineName, Class_ChatChannel) as IChatChannel;
end;


end.
