{ *****************************************************************************
  Implementing COM Component Callbacks in Delphi
  Code written for Delphi Informant publication

  Comments, questions, suggestions?
  Binh Ly, Systems Analyst (bly@brickhouse.com)
  Brickhouse Data Systems (http://www.brickhouse.com)
  *****************************************************************************
}
unit ChatEvent;

interface

uses
  ChatServer_TLB,
  ComObj,
  Classes
  ;

type
  TChatMessageEvent = procedure (const UserName, Message : string) of object;

  TChatEvent = class (TAutoIntfObject, IChatEvent)
  protected
    { IChatEvent }
    procedure GotMessage (const UserName, Message: WideString); safecall;
  protected
    FOnMessage : TChatMessageEvent;
  public
    constructor Create;
    property OnMessage : TChatMessageEvent read FOnMessage write FOnMessage;
  end;

implementation

uses
  Windows,
  ActiveX
  ;

{ TChatEvent }

procedure TChatEvent.GotMessage (const UserName, Message: WideString);
begin
  { IChatEvent.GotMessage callback implementation. we just trigger the
     OnMessage event.
  }
  if Assigned (OnMessage) then
    OnMessage (UserName, Message);
end;

constructor TChatEvent.Create;
var
  ifTypeLib : ITypeLib;
begin
  { enable both IDispatch binding using type library }
  OleCheck (LoadRegTypeLib(LIBID_ChatServer, 1, 0, 0, ifTypeLib));
  inherited Create (ifTypeLib, IChatEvent);

  { artificially increment ref count so that we don't get destroyed prematurely }
  //_AddRef;
end;

end.
