{ *****************************************************************************
  Implementing COM Component Callbacks in Delphi
  Code written for Delphi Informant publication

  Comments, questions, suggestions?
  Binh Ly, Systems Analyst (bly@brickhouse.com)
  Brickhouse Data Systems (http://www.brickhouse.com)
  *****************************************************************************
}
unit ChatConnection;

interface

uses
  ComObj, ActiveX, ChatServer_TLB, Classes;

type
  TChatConnection = class(TAutoObject, IChatConnection)
  protected
    { IChatConnection }
    function Get_ChatChannel: IChatChannel; safecall;
    procedure BroadcastMessage(const UserName, Message: WideString); safecall;
  protected
    procedure Initialize; override;
    destructor Destroy; override;
  end;

const
  { used to keep track of the number of active chat connections }
  ChatConnections : integer = 0;

implementation

uses
  ComServ,
  ChatChannel
  ;

{ TChatConnection }

procedure TChatConnection.Initialize;
begin
  inherited;

  { increment count for every new connection }
  ChatConnections := ChatConnections + 1;
end;

destructor TChatConnection.Destroy;
begin
  inherited;

  { decrement count when connection terminates }
  ChatConnections := ChatConnections - 1;

  { when count does down to 0, we don't need the MainChatChannel instance anymore } 
  if (ChatConnections <= 0) then MainChatChannel := NIL;
end;

function TChatConnection.Get_ChatChannel: IChatChannel;
begin
  { returns the main chat channel for all chat connections }
  if (MainChatChannel = NIL) then
    MainChatChannel := TChatChannel.Create;
  Result := MainChatChannel;
end;

procedure TChatConnection.BroadcastMessage (const UserName, Message: WideString);
begin
  { called by the client when it wants to broadcast a chat message }
  if (MainChatChannel <> NIL) then
    MainChatChannel.BroadcastMessage (UserName, Message);
end;

initialization
  TAutoObjectFactory.Create(ComServer, TChatConnection, Class_ChatConnection, ciMultiInstance);
end.
