unit War_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Internal War Application Objects }
{ Version 6.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_War: TGUID = '{10B316A1-60E0-11D4-9126-F8E9F451A94A}';

const

{ Component class GUIDs }
  Class_WarApplication: TGUID = '{10B316B0-60E0-11D4-9126-F8E9F451A94A}';
  Class_OrderAction: TGUID = '{10B316B3-60E0-11D4-9126-F8E9F451A94A}';
  Class_LabAction: TGUID = '{10B316B4-60E0-11D4-9126-F8E9F451A94A}';
  Class_SpyAction: TGUID = '{10B316B5-60E0-11D4-9126-F8E9F451A94A}';
  Class_ShipAction: TGUID = '{10B316B6-60E0-11D4-9126-F8E9F451A94A}';

type

{ Forward declarations: Interfaces }
  IWarAction = interface;
  IWarActionDisp = dispinterface;
  IOrderAction = interface;
  IOrderActionDisp = dispinterface;
  ILabAction = interface;
  ILabActionDisp = dispinterface;
  ISpyAction = interface;
  ISpyActionDisp = dispinterface;
  IShipAction = interface;
  IShipActionDisp = dispinterface;
  IWarApplication = interface;
  IWarApplicationDisp = dispinterface;
  WarApplicationEvents = dispinterface;
  WarActionEvents = dispinterface;
  ShipActionEvents = dispinterface;

{ Forward declarations: CoClasses }
  WarApplication = IWarApplication;
  OrderAction = IOrderAction;
  LabAction = ILabAction;
  SpyAction = ISpyAction;
  ShipAction = IShipAction;

{ Generic War Action object. }

  IWarAction = interface(IDispatch)
    ['{10B316AA-60E0-11D4-9126-F8E9F451A94A}']
    function Get_Sector: Integer; safecall;
    procedure Set_Sector(Value: Integer); safecall;
    function Get_Hor: Integer; safecall;
    procedure Set_Hor(Value: Integer); safecall;
    function Get_Ver: Integer; safecall;
    procedure Set_Ver(Value: Integer); safecall;
    function Get_CurrentSector: Integer; safecall;
    procedure Set_CurrentSector(Value: Integer); safecall;
    function Get_CurrentHor: Integer; safecall;
    procedure Set_CurrentHor(Value: Integer); safecall;
    function Get_CurrentVer: Integer; safecall;
    procedure Set_CurrentVer(Value: Integer); safecall;
    function Get_RecordName: WideString; safecall;
    procedure Set_RecordName(const Value: WideString); safecall;
    function Get_RegNum: Integer; safecall;
    procedure Set_RegNum(Value: Integer); safecall;
    function Get_Sprite: Integer; safecall;
    function Get_RecNo: Integer; safecall;
    procedure Set_RecNo(Value: Integer); safecall;
    function Get_RecordCount: Integer; safecall;
    function Get_EOF: WordBool; safecall;
    function Get_BOF: WordBool; safecall;
    procedure Edit; safecall;
    procedure First; safecall;
    procedure Last; safecall;
    procedure Next; safecall;
    procedure Prev; safecall;
    function Get_Dummy1a: Integer; safecall;
    procedure Set_Dummy1a(Value: Integer); safecall;
    function Get_Dummy2a: Integer; safecall;
    procedure Set_Dummy2a(Value: Integer); safecall;
    function Get_Dummy3a: Integer; safecall;
    procedure Set_Dummy3a(Value: Integer); safecall;
    function Get_Dummy4a: Integer; safecall;
    procedure Set_Dummy4a(Value: Integer); safecall;
    function Get_Dummy5a: Integer; safecall;
    procedure Set_Dummy5a(Value: Integer); safecall;
    procedure Dummy1m; safecall;
    procedure Dummy2m; safecall;
    procedure Dummy3m; safecall;
    procedure Dummy4m; safecall;
    procedure Dummy5m; safecall;
    property Sector: Integer read Get_Sector write Set_Sector;
    property Hor: Integer read Get_Hor write Set_Hor;
    property Ver: Integer read Get_Ver write Set_Ver;
    property CurrentSector: Integer read Get_CurrentSector write Set_CurrentSector;
    property CurrentHor: Integer read Get_CurrentHor write Set_CurrentHor;
    property CurrentVer: Integer read Get_CurrentVer write Set_CurrentVer;
    property RecordName: WideString read Get_RecordName write Set_RecordName;
    property RegNum: Integer read Get_RegNum write Set_RegNum;
    property Sprite: Integer read Get_Sprite;
    property RecNo: Integer read Get_RecNo write Set_RecNo;
    property RecordCount: Integer read Get_RecordCount;
    property EOF: WordBool read Get_EOF;
    property BOF: WordBool read Get_BOF;
    property Dummy1a: Integer read Get_Dummy1a write Set_Dummy1a;
    property Dummy2a: Integer read Get_Dummy2a write Set_Dummy2a;
    property Dummy3a: Integer read Get_Dummy3a write Set_Dummy3a;
    property Dummy4a: Integer read Get_Dummy4a write Set_Dummy4a;
    property Dummy5a: Integer read Get_Dummy5a write Set_Dummy5a;
  end;

{ DispInterface declaration for Dual Interface IWarAction }

  IWarActionDisp = dispinterface
    ['{10B316AA-60E0-11D4-9126-F8E9F451A94A}']
    property Sector: Integer dispid 1;
    property Hor: Integer dispid 2;
    property Ver: Integer dispid 3;
    property CurrentSector: Integer dispid 4;
    property CurrentHor: Integer dispid 5;
    property CurrentVer: Integer dispid 6;
    property RecordName: WideString dispid 7;
    property RegNum: Integer dispid 8;
    property Sprite: Integer readonly dispid 9;
    property RecNo: Integer dispid 10;
    property RecordCount: Integer readonly dispid 11;
    property EOF: WordBool readonly dispid 12;
    property BOF: WordBool readonly dispid 13;
    procedure Edit; dispid 14;
    procedure First; dispid 15;
    procedure Last; dispid 16;
    procedure Next; dispid 17;
    procedure Prev; dispid 18;
    property Dummy1a: Integer dispid 19;
    property Dummy2a: Integer dispid 20;
    property Dummy3a: Integer dispid 21;
    property Dummy4a: Integer dispid 22;
    property Dummy5a: Integer dispid 23;
    procedure Dummy1m; dispid 24;
    procedure Dummy2m; dispid 25;
    procedure Dummy3m; dispid 26;
    procedure Dummy4m; dispid 27;
    procedure Dummy5m; dispid 28;
  end;

{ Generic Action with Text }

  IOrderAction = interface(IWarAction)
    ['{10B316AB-60E0-11D4-9126-F8E9F451A94A}']
    function Get_Text: WideString; safecall;
    procedure Set_Text(const Value: WideString); safecall;
    function Get_Dummy1b: Integer; safecall;
    procedure Set_Dummy1b(Value: Integer); safecall;
    function Get_Dummy2b: Integer; safecall;
    procedure Set_Dummy2b(Value: Integer); safecall;
    procedure NewEntry(const InitialText: WideString; NumberOfEntries: Integer); safecall;
    procedure DeleteEntry; safecall;
    procedure Dummy1n; safecall;
    procedure Dummy2n; safecall;
    property Text: WideString read Get_Text write Set_Text;
    property Dummy1b: Integer read Get_Dummy1b write Set_Dummy1b;
    property Dummy2b: Integer read Get_Dummy2b write Set_Dummy2b;
  end;

{ DispInterface declaration for Dual Interface IOrderAction }

  IOrderActionDisp = dispinterface
    ['{10B316AB-60E0-11D4-9126-F8E9F451A94A}']
    property Sector: Integer dispid 1;
    property Hor: Integer dispid 2;
    property Ver: Integer dispid 3;
    property CurrentSector: Integer dispid 4;
    property CurrentHor: Integer dispid 5;
    property CurrentVer: Integer dispid 6;
    property RecordName: WideString dispid 7;
    property RegNum: Integer dispid 8;
    property Sprite: Integer readonly dispid 9;
    property RecNo: Integer dispid 10;
    property RecordCount: Integer readonly dispid 11;
    property EOF: WordBool readonly dispid 12;
    property BOF: WordBool readonly dispid 13;
    procedure Edit; dispid 14;
    procedure First; dispid 15;
    procedure Last; dispid 16;
    procedure Next; dispid 17;
    procedure Prev; dispid 18;
    property Dummy1a: Integer dispid 19;
    property Dummy2a: Integer dispid 20;
    property Dummy3a: Integer dispid 21;
    property Dummy4a: Integer dispid 22;
    property Dummy5a: Integer dispid 23;
    procedure Dummy1m; dispid 24;
    procedure Dummy2m; dispid 25;
    procedure Dummy3m; dispid 26;
    procedure Dummy4m; dispid 27;
    procedure Dummy5m; dispid 28;
    property Text: WideString dispid 29;
    property Dummy1b: Integer dispid 30;
    property Dummy2b: Integer dispid 31;
    procedure NewEntry(const InitialText: WideString; NumberOfEntries: Integer); dispid 32;
    procedure DeleteEntry; dispid 33;
    procedure Dummy1n; dispid 34;
    procedure Dummy2n; dispid 35;
  end;

{ Research Action }

  ILabAction = interface(IOrderAction)
    ['{10B316AC-60E0-11D4-9126-F8E9F451A94A}']
    function Get_SciPerLab: Integer; safecall;
    procedure Set_SciPerLab(Value: Integer); safecall;
    function Get_NumberOfLabs: Integer; safecall;
    procedure Set_NumberOfLabs(Value: Integer); safecall;
    function Get_EstimatedMajor: Integer; safecall;
    procedure Set_EstimatedMajor(Value: Integer); safecall;
    function Get_EstimatedMinor: Integer; safecall;
    procedure Set_EstimatedMinor(Value: Integer); safecall;
    property SciPerLab: Integer read Get_SciPerLab write Set_SciPerLab;
    property NumberOfLabs: Integer read Get_NumberOfLabs write Set_NumberOfLabs;
    property EstimatedMajor: Integer read Get_EstimatedMajor write Set_EstimatedMajor;
    property EstimatedMinor: Integer read Get_EstimatedMinor write Set_EstimatedMinor;
  end;

{ DispInterface declaration for Dual Interface ILabAction }

  ILabActionDisp = dispinterface
    ['{10B316AC-60E0-11D4-9126-F8E9F451A94A}']
    property Sector: Integer dispid 1;
    property Hor: Integer dispid 2;
    property Ver: Integer dispid 3;
    property CurrentSector: Integer dispid 4;
    property CurrentHor: Integer dispid 5;
    property CurrentVer: Integer dispid 6;
    property RecordName: WideString dispid 7;
    property RegNum: Integer dispid 8;
    property Sprite: Integer readonly dispid 9;
    property RecNo: Integer dispid 10;
    property RecordCount: Integer readonly dispid 11;
    property EOF: WordBool readonly dispid 12;
    property BOF: WordBool readonly dispid 13;
    procedure Edit; dispid 14;
    procedure First; dispid 15;
    procedure Last; dispid 16;
    procedure Next; dispid 17;
    procedure Prev; dispid 18;
    property Dummy1a: Integer dispid 19;
    property Dummy2a: Integer dispid 20;
    property Dummy3a: Integer dispid 21;
    property Dummy4a: Integer dispid 22;
    property Dummy5a: Integer dispid 23;
    procedure Dummy1m; dispid 24;
    procedure Dummy2m; dispid 25;
    procedure Dummy3m; dispid 26;
    procedure Dummy4m; dispid 27;
    procedure Dummy5m; dispid 28;
    property Text: WideString dispid 29;
    property Dummy1b: Integer dispid 30;
    property Dummy2b: Integer dispid 31;
    procedure NewEntry(const InitialText: WideString; NumberOfEntries: Integer); dispid 32;
    procedure DeleteEntry; dispid 33;
    procedure Dummy1n; dispid 34;
    procedure Dummy2n; dispid 35;
    property SciPerLab: Integer dispid 36;
    property NumberOfLabs: Integer dispid 37;
    property EstimatedMajor: Integer dispid 38;
    property EstimatedMinor: Integer dispid 39;
  end;

{ Espionage Action }

  ISpyAction = interface(IOrderAction)
    ['{10B316AD-60E0-11D4-9126-F8E9F451A94A}']
    function Get_SpyType: Integer; safecall;
    procedure Set_SpyType(Value: Integer); safecall;
    property SpyType: Integer read Get_SpyType write Set_SpyType;
  end;

{ DispInterface declaration for Dual Interface ISpyAction }

  ISpyActionDisp = dispinterface
    ['{10B316AD-60E0-11D4-9126-F8E9F451A94A}']
    property Sector: Integer dispid 1;
    property Hor: Integer dispid 2;
    property Ver: Integer dispid 3;
    property CurrentSector: Integer dispid 4;
    property CurrentHor: Integer dispid 5;
    property CurrentVer: Integer dispid 6;
    property RecordName: WideString dispid 7;
    property RegNum: Integer dispid 8;
    property Sprite: Integer readonly dispid 9;
    property RecNo: Integer dispid 10;
    property RecordCount: Integer readonly dispid 11;
    property EOF: WordBool readonly dispid 12;
    property BOF: WordBool readonly dispid 13;
    procedure Edit; dispid 14;
    procedure First; dispid 15;
    procedure Last; dispid 16;
    procedure Next; dispid 17;
    procedure Prev; dispid 18;
    property Dummy1a: Integer dispid 19;
    property Dummy2a: Integer dispid 20;
    property Dummy3a: Integer dispid 21;
    property Dummy4a: Integer dispid 22;
    property Dummy5a: Integer dispid 23;
    procedure Dummy1m; dispid 24;
    procedure Dummy2m; dispid 25;
    procedure Dummy3m; dispid 26;
    procedure Dummy4m; dispid 27;
    procedure Dummy5m; dispid 28;
    property Text: WideString dispid 29;
    property Dummy1b: Integer dispid 30;
    property Dummy2b: Integer dispid 31;
    procedure NewEntry(const InitialText: WideString; NumberOfEntries: Integer); dispid 32;
    procedure DeleteEntry; dispid 33;
    procedure Dummy1n; dispid 34;
    procedure Dummy2n; dispid 35;
    property SpyType: Integer dispid 36;
  end;

{ Ship Action }

  IShipAction = interface(IWarAction)
    ['{10B316AE-60E0-11D4-9126-F8E9F451A94A}']
    function Get_Orders(X: Integer): Integer; safecall;
    procedure Set_Orders(X: Integer; Value: Integer); safecall;
    function Get_Hostility: Integer; safecall;
    procedure Set_Hostility(Value: Integer); safecall;
    function Get_UID: Integer; safecall;
    procedure Buy(What: OleVariant); safecall;
    procedure Sell; safecall;
    property Orders[X: Integer]: Integer read Get_Orders write Set_Orders;
    property Hostility: Integer read Get_Hostility write Set_Hostility;
    property UID: Integer read Get_UID;
  end;

{ DispInterface declaration for Dual Interface IShipAction }

  IShipActionDisp = dispinterface
    ['{10B316AE-60E0-11D4-9126-F8E9F451A94A}']
    property Sector: Integer dispid 1;
    property Hor: Integer dispid 2;
    property Ver: Integer dispid 3;
    property CurrentSector: Integer dispid 4;
    property CurrentHor: Integer dispid 5;
    property CurrentVer: Integer dispid 6;
    property RecordName: WideString dispid 7;
    property RegNum: Integer dispid 8;
    property Sprite: Integer readonly dispid 9;
    property RecNo: Integer dispid 10;
    property RecordCount: Integer readonly dispid 11;
    property EOF: WordBool readonly dispid 12;
    property BOF: WordBool readonly dispid 13;
    procedure Edit; dispid 14;
    procedure First; dispid 15;
    procedure Last; dispid 16;
    procedure Next; dispid 17;
    procedure Prev; dispid 18;
    property Dummy1a: Integer dispid 19;
    property Dummy2a: Integer dispid 20;
    property Dummy3a: Integer dispid 21;
    property Dummy4a: Integer dispid 22;
    property Dummy5a: Integer dispid 23;
    procedure Dummy1m; dispid 24;
    procedure Dummy2m; dispid 25;
    procedure Dummy3m; dispid 26;
    procedure Dummy4m; dispid 27;
    procedure Dummy5m; dispid 28;
    property Orders[X: Integer]: Integer dispid 29;
    property Hostility: Integer dispid 30;
    property UID: Integer readonly dispid 31;
    procedure Buy(What: OleVariant); dispid 32;
    procedure Sell; dispid 33;
  end;

{ Dispatch interface for WarApplication Object }

  IWarApplication = interface(IDispatch)
    ['{10B316AF-60E0-11D4-9126-F8E9F451A94A}']
    function Get_Connected: WordBool; safecall;
    function Get_Date: Integer; safecall;
    function Get_DateX: Integer; safecall;
    function Get_Debt: Double; safecall;
    procedure Set_Debt(Value: Double); safecall;
    function Get_Deficit: Double; safecall;
    procedure Set_Deficit(Value: Double); safecall;
    function Get_FileName: WideString; safecall;
    procedure Set_FileName(const Value: WideString); safecall;
    function Get_Funds: Double; safecall;
    procedure Set_Funds(Value: Double); safecall;
    function Get_Government: Integer; safecall;
    procedure Set_Government(Value: Integer); safecall;
    function Get_Income: Double; safecall;
    procedure Set_Income(Value: Double); safecall;
    function Get_Labs: LabAction; safecall;
    function Get_Law: Integer; safecall;
    procedure Set_Law(Value: Integer); safecall;
    function Get_Logo: WideString; safecall;
    procedure Set_Logo(const Value: WideString); safecall;
    function Get_Msgs: OrderAction; safecall;
    function Get_Modified: WordBool; safecall;
    procedure Set_Modified(Value: WordBool); safecall;
    function Get_Orders: OrderAction; safecall;
    function Get_PlayerName: WideString; safecall;
    function Get_PlayerNumber: Integer; safecall;
    function Get_Ships: IShipAction; safecall;
    function Get_Spies: SpyAction; safecall;
    function Get_StarChart: OleVariant; safecall;
    function Get_Results: OrderAction; safecall;
    function Get_Theme: WideString; safecall;
    procedure Set_Theme(const Value: WideString); safecall;
    function Get_TutorialMode: WordBool; safecall;
    function Get_Version: Double; safecall;
    procedure Connect; safecall;
    procedure Disconnect; safecall;
    procedure DoCancel; safecall;
    procedure Hide; safecall;
    procedure LoadFromFile(const aFileName: WideString); safecall;
    procedure Quit; safecall;
    procedure RegisterEditor(RegistrationCode: Integer); safecall;
    procedure SaveToFile(const aFileName: WideString); safecall;
    procedure Send(Command, Specifier: Integer; const Text: WideString); safecall;
    procedure SendFinished; safecall;
    procedure Show; safecall;
    procedure Transmit; safecall;
    procedure Update; safecall;
    function Get_TempFile: WideString; safecall;
    function Get_Dummy1: Integer; safecall;
    procedure Set_Dummy1(Value: Integer); safecall;
    function Get_Dummy2: Integer; safecall;
    procedure Set_Dummy2(Value: Integer); safecall;
    property Connected: WordBool read Get_Connected;
    property Date: Integer read Get_Date;
    property DateX: Integer read Get_DateX;
    property Debt: Double read Get_Debt write Set_Debt;
    property Deficit: Double read Get_Deficit write Set_Deficit;
    property FileName: WideString read Get_FileName write Set_FileName;
    property Funds: Double read Get_Funds write Set_Funds;
    property Government: Integer read Get_Government write Set_Government;
    property Income: Double read Get_Income write Set_Income;
    property Labs: LabAction read Get_Labs;
    property Law: Integer read Get_Law write Set_Law;
    property Logo: WideString read Get_Logo write Set_Logo;
    property Msgs: OrderAction read Get_Msgs;
    property Modified: WordBool read Get_Modified write Set_Modified;
    property Orders: OrderAction read Get_Orders;
    property PlayerName: WideString read Get_PlayerName;
    property PlayerNumber: Integer read Get_PlayerNumber;
    property Ships: IShipAction read Get_Ships;
    property Spies: SpyAction read Get_Spies;
    property StarChart: OleVariant read Get_StarChart;
    property Results: OrderAction read Get_Results;
    property Theme: WideString read Get_Theme write Set_Theme;
    property TutorialMode: WordBool read Get_TutorialMode;
    property Version: Double read Get_Version;
    property TempFile: WideString read Get_TempFile;
    property Dummy1: Integer read Get_Dummy1 write Set_Dummy1;
    property Dummy2: Integer read Get_Dummy2 write Set_Dummy2;
  end;

{ DispInterface declaration for Dual Interface IWarApplication }

  IWarApplicationDisp = dispinterface
    ['{10B316AF-60E0-11D4-9126-F8E9F451A94A}']
    property Connected: WordBool readonly dispid 1;
    property Date: Integer readonly dispid 2;
    property DateX: Integer readonly dispid 3;
    property Debt: Double dispid 4;
    property Deficit: Double dispid 5;
    property FileName: WideString dispid 6;
    property Funds: Double dispid 7;
    property Government: Integer dispid 8;
    property Income: Double dispid 9;
    property Labs: LabAction readonly dispid 10;
    property Law: Integer dispid 11;
    property Logo: WideString dispid 12;
    property Msgs: OrderAction readonly dispid 13;
    property Modified: WordBool dispid 14;
    property Orders: OrderAction readonly dispid 15;
    property PlayerName: WideString readonly dispid 16;
    property PlayerNumber: Integer readonly dispid 17;
    property Ships: IShipAction readonly dispid 18;
    property Spies: SpyAction readonly dispid 19;
    property StarChart: OleVariant readonly dispid 20;
    property Results: OrderAction readonly dispid 21;
    property Theme: WideString dispid 22;
    property TutorialMode: WordBool readonly dispid 23;
    property Version: Double readonly dispid 24;
    procedure Connect; dispid 25;
    procedure Disconnect; dispid 26;
    procedure DoCancel; dispid 27;
    procedure Hide; dispid 28;
    procedure LoadFromFile(const aFileName: WideString); dispid 29;
    procedure Quit; dispid 30;
    procedure RegisterEditor(RegistrationCode: Integer); dispid 31;
    procedure SaveToFile(const aFileName: WideString); dispid 32;
    procedure Send(Command, Specifier: Integer; const Text: WideString); dispid 33;
    procedure SendFinished; dispid 34;
    procedure Show; dispid 35;
    procedure Transmit; dispid 36;
    procedure Update; dispid 37;
    property TempFile: WideString readonly dispid 38;
    property Dummy1: Integer dispid 39;
    property Dummy2: Integer dispid 40;
  end;

{ Event Interface for War Application }

  WarApplicationEvents = dispinterface
    ['{10B316B1-60E0-11D4-9126-F8E9F451A94A}']
    procedure OnConnect; dispid 1;
    procedure OnDisconnect; dispid 2;
    procedure BeforeTransmit; dispid 3;
    procedure AfterTransmit; dispid 4;
    procedure BeforeUpdate; dispid 5;
    procedure AfterUpdate; dispid 6;
    procedure DoSend(var Wait: WordBool); dispid 7;
    procedure OnSave; dispid 8;
    procedure OnLoad; dispid 9;
    procedure OnClose; dispid 10;
    procedure OnStarChartClick; dispid 11;
    procedure OnStarChartDblClick; dispid 12;
  end;

{ Event Interface for Most WarActions }

  WarActionEvents = dispinterface
    ['{10B316B2-60E0-11D4-9126-F8E9F451A94A}']
    procedure Change; dispid 1;
    procedure Delete; dispid 2;
    procedure Move; dispid 3;
    procedure New; dispid 4;
    procedure Scroll; dispid 5;
  end;

{ Event Interface for Ship Action }

  ShipActionEvents = dispinterface
    ['{10B316B7-60E0-11D4-9126-F8E9F451A94A}']
    procedure Change; dispid 1;
    procedure Sell; dispid 2;
    procedure Move; dispid 3;
    procedure Buy; dispid 4;
    procedure Scroll; dispid 5;
  end;

{ WarApplication Object }

  CoWarApplication = class
    class function Create: IWarApplication;
    class function CreateRemote(const MachineName: string): IWarApplication;
  end;

{ Co-Class for Generic Action }

  CoOrderAction = class
    class function Create: IOrderAction;
    class function CreateRemote(const MachineName: string): IOrderAction;
  end;

{ Co-Class for Research Action }

  CoLabAction = class
    class function Create: ILabAction;
    class function CreateRemote(const MachineName: string): ILabAction;
  end;

{ Co-Class for Espionage Action }

  CoSpyAction = class
    class function Create: ISpyAction;
    class function CreateRemote(const MachineName: string): ISpyAction;
  end;

{ Co-Class for Ship Action }

  CoShipAction = class
    class function Create: IShipAction;
    class function CreateRemote(const MachineName: string): IShipAction;
  end;



implementation

uses ComObj;

class function CoWarApplication.Create: IWarApplication;
begin
  Result := CreateComObject(Class_WarApplication) as IWarApplication;
end;

class function CoWarApplication.CreateRemote(const MachineName: string): IWarApplication;
begin
  Result := CreateRemoteComObject(MachineName, Class_WarApplication) as IWarApplication;
end;

class function CoOrderAction.Create: IOrderAction;
begin
  Result := CreateComObject(Class_OrderAction) as IOrderAction;
end;

class function CoOrderAction.CreateRemote(const MachineName: string): IOrderAction;
begin
  Result := CreateRemoteComObject(MachineName, Class_OrderAction) as IOrderAction;
end;

class function CoLabAction.Create: ILabAction;
begin
  Result := CreateComObject(Class_LabAction) as ILabAction;
end;

class function CoLabAction.CreateRemote(const MachineName: string): ILabAction;
begin
  Result := CreateRemoteComObject(MachineName, Class_LabAction) as ILabAction;
end;

class function CoSpyAction.Create: ISpyAction;
begin
  Result := CreateComObject(Class_SpyAction) as ISpyAction;
end;

class function CoSpyAction.CreateRemote(const MachineName: string): ISpyAction;
begin
  Result := CreateRemoteComObject(MachineName, Class_SpyAction) as ISpyAction;
end;

class function CoShipAction.Create: IShipAction;
begin
  Result := CreateComObject(Class_ShipAction) as IShipAction;
end;

class function CoShipAction.CreateRemote(const MachineName: string): IShipAction;
begin
  Result := CreateRemoteComObject(MachineName, Class_ShipAction) as IShipAction;
end;


end.
