unit Unit2;

interface

uses
  Windows, ComObj, Project1_TLB, axctrls, ActiveX, Classes;

type
  TTestClass = class(TAutoObject, ITestClass
    {$IFDEF VER120}, IConnectionPointContainer {$ENDIF})
  private
    fcp: TConnectionPoints;
    fEventSink: TConnectionPoint;
  protected
    procedure initialize; override;
    destructor Destroy; override;
    procedure Method1; safecall;
    function ObjQueryInterface (const IID: TGUID; out Obj): HResult; override;
    {$IFDEF VER120}
    property ChatUsers : TConnectionPoints read fcp
      implements IConnectionPointContainer;
    {$ENDIF}
  end;

implementation

uses ComServ, Unit1;

procedure TTestClass.initialize;
begin
  Inherited Initialize;
  fcp := TConnectionPoints.Create(Self);
  fEventSink := Fcp.CreateConnectionPoint(ITestEvent, ckMulti, nil);
end;

destructor TTestClass.Destroy;
begin
  FEventSink.Free;
  fcp.Free;
  inherited destroy;
end;

procedure TTestClass.Method1;
var
  Enum : IEnumConnections;
  ConnectData : TConnectData;
  Fetched : Longint;
begin
  { loops through all client connections and issues the callback
  message broadcast }
  OleCheck ((fEventSink as IConnectionPoint).EnumConnections (Enum));
  while Enum.Next (1, ConnectData, @Fetched) = S_OK do
  begin
    try
      (ConnectData.pUnk as ITestEvent).Event1;
      ConnectData.pUnk := nil;
    except
      { if error happened, this callback client probably disconnected
        prematurely; therefore we just ignore the error and process all
        remaining clients.
      }
    end;  { except }
  end;  { while }
end;

function TTestClass.ObjQueryInterface (const IID: TGUID; out Obj): HResult;
begin
  Result := inherited ObjQueryInterface (IID, Obj);
  if not Succeeded (Result) then
    { delegate QueryInterface to FChatUsers for IConnectionPointContainer }
    if (IsEqualIID (IID, IConnectionPointContainer)) then
      if fcp.GetInterface (IID, Obj) then Result := S_OK;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TTestClass, Class_TestClass, ciMultiInstance);
end.
