unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComObj, War_TLB, WarObjs_TLB, Project1_TLB,
  ActiveX;

type
  TLocalEvent = procedure of object;
  TEventClass = class(TAutoIntfObject, ITestEvent)
    fOnEvent1: TLocalEvent;
  protected
    procedure Event1; safecall;
    {procedure EvConnect(const Sink: Iunknown; Connecting: Boolean);}
  public
    constructor Create;
    property OnEvent1 : TLocalEvent read fOnEvent1 write fOnEvent1;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    bCreateOLE: TButton;
    Edit2: TEdit;
    bTestLink: TButton;
    bKillOLE: TButton;
    procedure Button1Click(Sender: TObject);
    procedure bCreateOLEClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bTestLinkClick(Sender: TObject);
    procedure bKillOLEClick(Sender: TObject);
  private
    { Private declarations }
    fEventSink: TEventClass;
  public
    { Public declarations }
    Procedure EventCallBackProc;
  end;

var
  Form1: TForm1;
  E: ITestClass;

implementation

{$R *.DFM}

constructor TEventClass.Create;
var
  ifTypeLib : ITypeLib;
begin
  { enable both IDispatch binding using type library }
  OleCheck (LoadRegTypeLib(LIBID_Project1, 1, 0, 0, ifTypeLib));
  inherited Create (ifTypeLib, ITestEvent);

  { artificially increment ref count so that we don't get destroyed prematurely }
  //_AddRef;
end;

procedure TEventClass.Event1;
begin
  If Assigned(OnEvent1) then
    OnEvent1;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  E: IWarApplication;
  Z: IUnknown;
  {Y: OleVariant;
  X: IDispatch;
  T: IWarObjEvents;}
begin
  E := CreateOleObject('War.WarApplication') As IWarApplication;
  If VarIsEmpty(E) then
    ShowMessage('E is empty');
  {Z := E.Ships;
  If VarIsEmpty(Z) then
    ShowMessage('Z is empty');}
  If E.Ships.QueryInterface(ShipActionEvents, Z) <> 0 then
    ShowMessage('not =');
  {If X.QueryInterface(IOrderAction, Y) <> 0 then
    ShowMessage('not =');
  If E.Ships.QueryInterface(IWarApplication, Z) <> 0 then
    ShowMessage('not =');
  ShowMessage('Query Record Count...');
  ShowMessage(IntToStr(E.Ships.RecordCount));}
end;

procedure TForm1.bCreateOLEClick(Sender: TObject);
var
  cp : IConnectionPointContainer;
  cpp : IConnectionPoint;
  W: Integer; //I don't know why we need an Integer here
begin
  E := CreateCOMObject(Class_TestClass) As ITestClass;

  cp := E as IConnectionPointContainer;
  cp.FindConnectionPoint (ITestEvent, cpp);
  cpp.Advise (fEventSink as IUnknown, W);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  fEventSink := TEventClass.Create;
  fEventSink.OnEvent1 := EventCallBackProc;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  cp : IConnectionPointContainer;
  cpp : IConnectionPoint;
  W: Integer;
begin
  If not (E = nil) then
    begin
      cp := E as IConnectionPointContainer;
      cp.FindConnectionPoint (ITestEvent, cpp);
      W := 0; //I don't know why we need an Integer here
      cpp.UnAdvise (W);
    end;
  fEventSink.Free;
end;

Procedure TForm1.EventCallBackProc;
begin
  Edit1.Text := 'Success';
end;

procedure TForm1.bTestLinkClick(Sender: TObject);
begin
  E.Method1;
end;

procedure TForm1.bKillOLEClick(Sender: TObject);
begin
  {I guess E's reference count is automatically
  decremented on program termination
  E.Free}
end;

end.
