unit Project1_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Project1 Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Project1: TGUID = '{69359340-5485-11D5-8FDE-00C00C702F1A}';

const

{ Component class GUIDs }
  Class_TestClass: TGUID = '{69359342-5485-11D5-8FDE-00C00C702F1A}';

type

{ Forward declarations: Interfaces }
  ITestClass = interface;
  ITestClassDisp = dispinterface;
  ITestEvent = interface;
  ITestEventDisp = dispinterface;

{ Forward declarations: CoClasses }
  TestClass = ITestClass;

{ Dispatch interface for TestClass Object }

  ITestClass = interface(IDispatch)
    ['{69359341-5485-11D5-8FDE-00C00C702F1A}']
    procedure Method1; safecall;
  end;

{ DispInterface declaration for Dual Interface ITestClass }

  ITestClassDisp = dispinterface
    ['{69359341-5485-11D5-8FDE-00C00C702F1A}']
    procedure Method1; dispid 2;
  end;

{ Event Interface (Client side must implement) }

  ITestEvent = interface(IDispatch)
    ['{69359343-5485-11D5-8FDE-00C00C702F1A}']
    procedure Event1; safecall;
  end;

{ DispInterface declaration for Dual Interface ITestEvent }

  ITestEventDisp = dispinterface
    ['{69359343-5485-11D5-8FDE-00C00C702F1A}']
    procedure Event1; dispid 1;
  end;

{ TestClassObject }

  CoTestClass = class
    class function Create: ITestClass;
    class function CreateRemote(const MachineName: string): ITestClass;
  end;



implementation

uses ComObj;

class function CoTestClass.Create: ITestClass;
begin
  Result := CreateComObject(Class_TestClass) as ITestClass;
end;

class function CoTestClass.CreateRemote(const MachineName: string): ITestClass;
begin
  Result := CreateRemoteComObject(MachineName, Class_TestClass) as ITestClass;
end;


end.
