unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Procedure ListChildren(AppName: String; List: TStrings);

  Procedure _ListChildren(Parent: THandle; Indent: String);
  var
    H: THandle;
    Cs: Array[0..512] of Char;
  begin
    H := GetWindow(Parent, gw_Child);
    While not (H = 0) do
      begin
        GetWindowText(H, Cs, 512);
        List.Add(Indent + IntToStr(H) + ' ' + StrPas(Cs));
        _ListChildren(H, Indent + ' ');
        H := GetWindow(H, gw_HWNDNext);
      end;
  end;

var
  H: THandle;
begin
  H := FindWindow(nil, PChar(AppName));
  _ListChildren(H, '');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ListChildren('Mirc32', Memo1.Lines);
  //ListChildren('Untitled - Notepad', Memo1.Lines);
end;

end.
