unit uURLForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, CrawlProcs, ShellAPI;

type
  TURLForm = class(TForm)
    edtURL: TEdit;
    edtLevel: TEdit;
    edtUser: TEdit;
    edtPass: TEdit;
    stURL: TLabel;
    stLevel: TLabel;
    stUser: TLabel;
    stPass: TLabel;
    bOK: TButton;
    bCancel: TButton;
    bView: TButton;
    procedure bViewClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    Function Check(var X: TURL): Boolean;
  end;

var
  URLForm: TURLForm;

implementation

{$R *.DFM}

Function TURLForm.Check(var X: TURL): Boolean;
begin
  edtURL.Text := X.Link;
  edtLevel.Text := IntToStr(X.Level);
  edtUser.Text := X.User;
  edtPass.Text := X.Pass;
  If ShowModal = mrOK then
    begin
      X.Link := edtURL.Text;
      X.Level := StrToInt(edtLevel.Text);
      X.User := edtUser.Text;
      X.Pass := edtPass.Text;
    end;
  Result := ModalResult = mrOk;
end;

procedure TURLForm.bViewClick(Sender: TObject);
begin
  If Length(edtURL.Text) = 0 then
    Exit;
  if LowerCase(edtURL.Text) = 'stop' then
    Exit;
  ShellExecute(0, nil, PChar(edtURL.Text), nil, nil, 0);
end;

procedure TURLForm.FormShow(Sender: TObject);
begin
  edtURL.SetFocus;
end;

procedure TURLForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  If Key = #27 then
    ModalResult := mrCancel;
end;

end.
