unit uSockThread;

interface

uses
  Windows, Messages, SysUtils, WinSockA, ShellAPI, mStrin32,
  CrawlProcs, uCrawlControls;

const
  wm_BrowseComplete   = wm_User + 50;
  wm_Break            = wm_User + 51;
  wm_Finished         = wm_User + 52;
  wm_Reply            = wm_User + 53;
  wm_DownloadComplete = wm_User + 54;

type
  TReplyImportance = (rNone, rSocketMessage, rForMemo);

procedure BrowseURL(aURL, aUser, aPass: Shortstring);

procedure CloseSockets;

procedure DownloadNextFile;

function GetErrorText: string;

function GetReply(Importance: TReplyImportance): string;

function GetStatusstring(Status: Integer): string;

procedure SetErrorText(const R: string);

procedure StopDownLoad;

var
  MaxLevel: Integer;
  DFile, Destination: string;
  Lc: string;
  LastStatus: Integer;
  BytesLoaded: Integer;
  ConnectAddress: string;
  Response: Integer;
  CurrentTask: Integer;
  AutoDisplay: Boolean = True;
  Count: Integer;
  MinFileSize: Integer = 4096;

implementation

uses
  uMainForm;

const
  winsocket = 'Ws2_32.dll';

  procedure DoneURL(B: string); forward;
  function IsURLDone(B: string): Boolean; forward;
  function ReadFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';
  function send(s: TSocket; Buf: Pointer; len, flags: Integer): Integer; stdcall; external winsocket;
  function WriteFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';

var
  hSockThread: THandle;
  MustClose: Boolean = False;
  hCriticalSection: TRTLCriticalSection;
  stErrorText: string;
  stReplyText: string;
  ReplyImportance: TReplyImportance;
  GetURL: string;
  //Lc: string;
  SendData: string;
  //URL: string;
  hBrowseEvent, hCloseEvent, hSockEvent, hLSockEvent,
    hLoadNextEvent, hAbortEvent: THandle;
  Remote_Addr: TSockAddrIn;
  SockHandle: THandle;
  InBuf: Array[0..256] of Char;
  ImageViewer: THandle = 0;
  fh: THandle;

procedure DoError(Msg: string);
var
  A: string;
  E: Integer;
begin
  E := WSAGetLastError;
  A := GetErrorMsg(E);
  if Length(A) > 0 then
    A := A + '(#' + IntToStr(E) + ')'
  else
    A := IntToStr(E);
  SetErrorText(Msg + ': ' + A);
end;

procedure DoReply(Msg: string; Importance: TReplyImportance);
begin
  EnterCriticalSection(hCriticalSection);
  stReplyText := Msg;
  LeaveCriticalSection(hCriticalSection);
  PostMessage(MainForm.Handle, wm_Reply, 0, 0);
end;

function GetReply(Importance: TReplyImportance): string;
begin
  EnterCriticalSection(hCriticalSection);
  if ReplyImportance >= Importance then
    Result := stReplyText
  else
    Result := '';
  stReplyText := '';
  LeaveCriticalSection(hCriticalSection);
end;

procedure AddFoundURL(A: string);
var
  I: Integer;
  T: TURL;
  X: string;
begin
  I := AnsiPos('#', A);
  if I > 0 then
    A := My_Substring(A, 1, I - 1);
  if AnsiPos('mailto:', LowerCase(A)) > 0 then
    Exit;
  if AnsiPos('irc:', LowerCase(A)) > 0 then
    Exit;
  //To check rules: excract URL into X
  X := A;
  if AnsiPos(':', X) > 0 then
    X := My_Substring(X, 8, -1);
  For I := 1 to Length(X) do
    if (X[I] = '/') OR (X[I] = '/') then
      begin
        X := My_Substring(X, 1, I - 1);
        Break;
      end;

  if not RulesAllow(X, A) then
    begin
      DoReply('Skipping '  + A + ' by rule', rForMemo);
      Exit;
    end;
  if not FoundURLS.LookFor(A) then
    if not IsURLDone(A) then
      begin
        T := CurrentURL;
        T.Link := A;
        T.Level := T.Level + 1;
        if ((MaxLevel > -1) and (T.Level <= MaxLevel)) OR
           (MaxLevel = -1) then
          FoundURLS.Items.Add(URLToStr(T));
      end;
end;

procedure BrowseURL(aURL, aUser, aPass: Shortstring);
var
  I, J: Integer;
  A, B, F: string;
begin
  DoneURL(aURL);
  A := aURL;
  if not (A[Length(A)] = '/') and (AnsiPos('?', A) = 0) then
    A := A + '/';
  //Look for first / after http://and split
  if AnsiPos(':', A) > 0 then
    A := My_Substring(A, 8, -1);
  J := 0;
  For I := 1 to Length(A) do
    if (A[I] = '/') OR (A[I] = '/') then
      begin
        J := I;
        Break;
      end;
  if J = 0 then
    Exit;
  ConnectAddress := My_Substring(A, 1, J - 1);
  GetURL := My_Substring(A, J, -1);
  //Check URL for */index.html/
  B := '';
  F := '';
  For I := Length(GetURL) - 4 to Length(GetURL) - 1 do
    B := B + GetURL[I];
  B := LowerCase(B);
  if (B = '.htm') OR (B = 'html') then
    begin
      For I := Length(GetURL) - 1 downto 1 do
        if GetURL[I] = '/' then
          begin
            F := My_Substring(GetURL, I + 1, Length(GetURL) - 1);
            GetURL := My_Substring(GetURL, 1, I);
            Break;
          end;
    end;

  if Length(aUser) > 0 then
    A := ' User/Pass: ' + aUser + '/' + aPass
  else
    A := '';
  //!Memo1.Lines.Add('Looking up ' + ConnectAddress + URL + F + A);
  Lc := '';

  A := 'GET ' + GetURL + F + ' HTTP/1.1' + #13#10 +
    'Host: ' + ConnectAddress + #13#10 +
    'Connection: Close' + #13#10;
  A := A + #13#10;
  SendData := A;
  //Signal a Browse Event
  SetEvent(hBrowseEvent);
end;

function BuildURL(FileName: string): string;
var
  A, B, URL2: string;
  I: Integer;
begin
  if AnsiPos('http://', LowerCase(FileName)) = 1 then
    begin
      Result := FileName;
      Exit;
    end;
  if AnsiPos(LowerCase(ConnectAddress), LowerCase(FileName)) = 1 then
    begin
      Result := FileName;
      Exit;
    end;

  //Sometimes we have to strip a ? from the URL
  URL2 := GetURL;
  I := AnsiPos('?', URL2);
  if I > 0 then
    URL2 := My_Substring(URL2, 1, I - 1);

  A := ConnectAddress + URL2;
  B := FileName;
  if (Length(A) > 0) and (A[Length(A)] = '\') and
     (Length(B) > 0) and (B[1] = '\') then
     B := My_Substring(B, 2, -1);
  if (Length(A) > 0) and (A[Length(A)] = '/') and
     (Length(B) > 0) and (B[1] = '/') then
     B := My_Substring(B, 2, -1);
  Result := A + B;
end;

procedure CloseSockets;
begin
  MustClose := True;
  SetEvent(hCloseEvent);
  WaitForSingleObject(hSockThread, Infinite);
end;

procedure DoConnect(Resolve: Boolean; SockEvent: THandle);
var
  Remote_Host: PHostEnt;
  Remote_Addr_In: PSockAddrIn;
  I: Integer;
begin
  if Resolve then
    begin
      Remote_Host := GetHostByName(PChar(ConnectAddress));
      if Remote_Host = nil then
        begin
          DoError('GetHostbyName Error');
          Exit;
        end;

      Remote_Addr_In := Addr(Remote_Addr);

      //Turn Remote_Host into an address
      Move(Pointer(Remote_Host^.h_addr_list^)^, Remote_Addr.sin_addr.S_addr, 4);

      DoReply('Resolved to: ' + StrPas(inet_nToA(PInAddr(@Remote_Addr)^)), rSocketMessage);

      Remote_addr_In^.sin_family := AF_INET;
      Remote_addr_in^.sin_port := htons(80);
    end;

  SockHandle := socket(AF_Inet, Sock_Stream, IPProto_TCP);
  if SockHandle = Invalid_Socket then
    begin
      DoError('Create socket error');
      Exit;
    end;

  I := Connect(SockHandle, Remote_Addr, Sizeof(TSockAddr));
  if I = Socket_Error then
    begin
      DoError('Connect Error');
      Exit;
    end;

  I := WSAEventSelect(SockHandle, SockEvent, Fd_Connect OR FD_Close OR FD_Read OR FD_Write);
  if I = Socket_Error then
    begin
      DoError('EventSelect Error');
      Exit;
    end;
end;

procedure DoneURL(B: string);
var
  D: Integer;
  W: DWord;
begin
  if IsURLDone(B) then
    exit;
  D := Length(B);
  SetFilePointer(hFoundFile, 0, nil, File_End);
  WriteFile(hFoundFile, @D, Sizeof(Integer), @W, nil);
  WriteFile(hFoundFile, @B, D, @W, nil);
end;

procedure DownloadNextFile;
var
  FileName, GetURL, Server: string;
  L: string;
  I: Integer;
  A, M: string;
  DoBreak: Boolean;

  function RecurseMD(Data: string; Rest: string; Blank: Integer): Boolean;
  var
    K: Integer;
    R: string;
  begin
    //Recursively make directories
    Result := True;
    K := AnsiPos(':', Data);
    if K > 0 then
      begin
        Rest := My_Substring(Data, 1, K + 1);
        RecurseMD(My_Substring(Data, K + 2, -1), Rest, Blank + 1);
        Exit;
      end;
    K := AnsiPos('\', Data);
    if K > 0 then
      begin
        R := Rest + My_Substring(Data, 1, K);
        CreateDirectory(PChar(R), nil);
        RecurseMD(
          My_Substring(Data, K + 1, -1),
          R,
          Blank + 1);
      end;
  end;

  procedure DoMessage;
  begin
    if Length(M) > 0 then
      DoReply(M, rForMemo);
    M := '';
  end;

begin
  //if CurrentTask = wt_Resolving then
  //  Exit;
  CurrentTask := 0;
  M := '';
  //Reset Timer Count
  Count := 0;

  DoBreak := False;
  if UserBreak then
    DoBreak := True;
  if (lbWork.Items.Count > 0) and (lbWork.URL(0) = 'STOP') then
    begin
      DoBreak := True;
      lbWork.Items.Delete(0);
    end;
  if not DoBreak and (lbWork.Items.Count = 0) and (FoundURLs.Items.Count > 0) and (FoundURLs.Items[0] = 'STOP') then
    begin
      DoBreak := True;
      FoundURLs.Items.Delete(0);
    end;
  if DoBreak then
    begin
      PostMessage(MainForm.Handle, wm_Break, 0, 0);
      CurrentTask := wt_None;
      Exit;
    end;

  if lbWork.Items.Count = 0 then
    begin
      if FoundURLs.Items.Count > 0 then
        begin
          A := FoundURLS.URL(0);
          CurrentURL := StrToURL(FoundURLs.Items[0]);
          CurrentURL.Level := CurrentURL.Level + 1;
          FoundURLS.Items.Delete(0);
          BrowseURL(A, CurrentURL.User, CurrentURL.Pass);
          Exit;
        end;
      CurrentURL.User := '';
      CurrentURL.Pass := '';
      PostMessage(MainForm.Handle, wm_Finished, 0, 0);
      Exit;
    end;

  inc(dlcount);

  FileName := lbWork.URL(0);
  //Before we get started, if there is a leading http://
  //then we need to override the _Add and restore it after
  //XAdd := ConnectAddress;
  I := AnsiPos('http://', LowerCase(FileName));
  if I = 1 then
    begin
      FileName := My_Substring(FileName, 8, -1);
      I := AnsiPos('/', FileName);
      if I = 0 then
        I := AnsiPos('\', FileName);
      //if I = 0 then we couldn't make sense of http://www.abc.com
      //So that means that this was somehow placed in wrong listbox.
      //Try BrowseURL
      if I = 0 then
        begin
          AddFoundURL(lbWork.URL(0));
          if lbWork.Items.Count > 0 then
            lbWork.Items.Delete(0);
          DownLoadNextFile;
          Exit;
        end;
      //XAdd := My_Substring(FileName, 1, I - 1);
      //FileName := My_Substring(FileName, I + 1, -1);
    end;

  DFile := Destination;
  DFile := DFile + FileName;

  //Scour DFile for Illegal Characters
  For I := 1 to Length(DFile) do
    if DFile[I] = '?' then
      DFile[I] := '_';
  //Remove any http://
  I := AnsiPos('http://', LowerCase(DFile));
  while I > 0 do
    begin
      DFile :=
        My_Substring(DFile, 1, I - 1) +
        My_Substring(DFile, I + 7, -1);
      I := AnsiPos('http://', LowerCase(DFile));
    end;
  For I := 1 to Length(DFile) do
    if DFile[I] = '/' then
      DFile[I] := '\';

  //Create the directory
  if not CreateDirectory(PChar(Destination + ConnectAddress), nil) then
    begin
      I := GetLastError;
      if not (I = 183) then
        begin
          DoReply('Create Directory Error 1: ' + Destination + ConnectAddress, rForMemo);
          DoReply('Error #' + IntToStr(I), rForMemo);
          Exit;
        end;
    end;
  L := '';

  RecurseMD(DFile, '', 0);

  M := DFile;
  if lbWork.Items.Count > 0 then
    lbWork.Items.Delete(0);
  Fc := '';
  CanWrite := False;

  //Does File already exist?
  if FileExists(DFile) then
    begin
      M := 'Skipping ' + M + ' (already exists)';
      DoMessage;
      DownLoadNextFile;
      Exit;
    end;

  //Shouldn't be necessary, but there's some kind of
  //resource-leak going on
  Closehandle(Fh);
  //Open the Destination File
  Fh := CreateFile(PChar(DFile), Generic_Read OR Generic_Write,
    File_Share_Read OR File_Share_Write, nil, Create_Always, 0, 0);
  if Fh = INVALID_HandLE_VALUE then
    begin
      DoReply('File Creation Error #' +
        IntToStr(GetLastError) + #13#10 +
        'Creating ' + DFile, rForMemo);
      DownLoadNextFile;
      Exit;
    end;

  if FileName[1] = '/' then
    GetURL := My_Substring(FileName, 2, -1)
  else
    begin
      A := FileName;
      I := AnsiPos('http://', LowerCase(A));
      if I > 0 then
        A := My_Substring(A, I + 7, -1);
      I := AnsiPos('/', A);
      if I = 0 then
        begin
          //Skip
          M := 'Skipping ' + M + ' (invalid URL)';
          DoMessage;
          DownLoadNextFile;
          Exit;
        end;
      GetURL := My_Substring(A, I + 1, -1);
    end;

  //Memo1.Lines.Add('File ' + FileName);
  //Memo1.Lines.Add('URL ' + URL);
  //Memo1.Lines.Add('GET ' + GetURL);

  Server := ConnectAddress;
  DoMessage;
  A := 'GET /' + GetURL + ' HTTP/1.1' + #13#10 +
    'Host: ' + ConnectAddress + #13#10 +
    //'Referer: ' + ConnectAddress + #13#10 +
    'Connection: Close' + #13#10;
  //Part of near-future implementation: USER-AUTH
  //if Length(CurrentURL.User) > 0 then
  //  A := A + #13#10 +
  //       'User: ' + CurrentURL.User + #13#10 +
  //       'Pass: ' + CurrentURL.Pass;
  A := A + #13#10;
  SendData := A;
  //Signal a Load Event
  SetEvent(hLoadNextEvent);

  //Part of Near-future implementation: USER-AUTH
  //if Length(CurrentURL.User) > 0 then
  //  Memo1.Lines.Add('User/Pass: ' + CurrentURL.User + '/' + CurrentURL.Pass);
end;

function GetErrorText: string;
begin
  EnterCriticalSection(hCriticalSection);
  Result := stErrorText;
  LeaveCriticalSection(hCriticalSection);
end;

function GetStatusstring(Status: Integer): string;
var
  A: string;
begin
  A := 'Unknown Status Code';
  case Status of
    301: A := 'Moved permanently';
    302: A := 'Moved temporarily';
    304: A := 'Not modified';
    400: A := 'Bad request';
    401: A := 'Unauthorized';
    403: A := 'Forbidden';
    404: A := 'Not found';
    500: A := 'Server error';
    501: A := 'Not implemented (Can''t fulfill)';
    502: A := 'Bad gateway';
    503: A := 'Service unavailable';
  else
    begin
      if (Status >= 300) and (Status < 400) then
        //URL Moved
        A := ' URL has been removed.';
      if (Status >= 400) and (Status < 500) then
        //Error
        A := ' Error loading URL';
      if (Status >= 500) and (Status < 600) then
        //Server Error
        A := ' Server Error.';
    end;
  end;
  Result := A + ' (#' + IntToStr(Status) + ')';
end;

function GetText(B: string): string;
var
  D: Integer;
begin
  //Pull the text out of a <a href="abc">
  Result := '';
  D := AnsiPos('=', B);
  if D = 0 then Exit;
  B := My_Substring(B, D + 1, -1);
  //Cut off any remaining leading spaces
  while (Length(B) > 0) and (B[1] = ' ') do
    B := My_Substring(B, 2, -1);
  if Length(B) = 0 then Exit;
  //Try to Isolate URL from " or '
  if B[1] = '"' then
    begin
      B := My_Substring(B, 2, -1);
      For D := 1 to Length(B) do
        if B[D] = '"' then
          begin
            B := My_Substring(B, 1, D - 1);
            Break;
          end;
    end
  else
    if B[1] = '''' then
      begin
        B := My_Substring(B, 2, -1);
        For D := 1 to Length(B) do
          if B[D] = '''' then
            begin
              B := My_Substring(B, 1, D - 1);
              Break;
            end;
      end
    else
      if AnsiPos('>', B) > 0 then
        B := My_stringToEx(B, '>');
  Result := B;
end;

procedure HTMLLoaded;
var
  A, Stat: string;
  J: Integer;

  function CanItem(B: string): Boolean;
  begin
    Result := RulesAllow(ConnectAddress, B);
    if not Result then
      DoReply('Skipping '  + B + ' by rule', rForMemo);
  end;

  function NextTag(Tag: string; Data: string): string;
  var
    I, J: Integer;
    A: string;
  Label
    JumpBack;
  begin
    Result := '';
    //Chop off leading character
    Data := My_Substring(Data, 2, -1);

    JumpBack:

    I := AnsiPos(Tag, LowerCase(Data));
    if I < 1 then
      Exit;

    //if <Script> appears in Data before I, then skip to </script>
    J := AnsiPos('<script', LowerCase(Data));
    if (J > 0) and (J <= I) then
      begin
        J := AnsiPos('</script>', LowerCase(Data));
        if (J < 1) OR (J + 5 > Length(Data)) then Exit;
        Data := My_Substring(Data, J + 5, -1);
        Goto JumpBack;
      end;

    A := My_Substring(Data, I, -1);
    Result := A;
  end;

  function URLDone(A: string): Boolean;

    function InList2(S: TURLBox): Boolean;
    var
      I: Integer;
      R: Boolean;
    begin
      R := False;
      For I := 0 to S.Items.Count - 1 do
        if LowerCase(S.URL(I)) = A then
          begin
            R := True;
            Break;
          end;
      Result := R;
    end;

  begin
    Result := False;
    if Length(A) < 2 then
      Result := True;
    A := LowerCase(A);
    if InList2(lbWork) OR InList2(FoundURLs) then
      begin
        Result := True;
        Exit;
      end;
    if IsURLDone(A) then
      begin
        Result := True;
        Exit;
      end;
    //Automatically filter out sorts like ?N=D.
    //any ? may cause infinite recursion (eg ?N=D/?N=D/?N=D)
    //Due to Apache's default directory index scheme
    if AnsiPos('/?', A) > 0 then
      Result := True;
  end;

  procedure ProcessPic;
  var
    B: string;
    K: Integer;
  begin
    K := AnsiPos('src=', LowerCase(A));
    if K = 0 then Exit;
    B := My_Substring(A, K + 3, -1);
    B := GetText(B);
    if Length(B) = 0 then
      Exit;
    //if RulesAllow(CurrentURL.Link
    B := BuildURL(B);
    if CanItem(B) then
      if not URLDone(B) then
        lbWork.Items.Add(B);
  end;

  procedure ProcessUrl;
  var
    B, C: string;
    D: Integer;
    T: TURL;
  begin
    //There are various kinds of URLs.
    //<a is already removed from <a href=
    //      href = http://www.abc.com>
    //      href = "http://www.abc.com">
    //      href = 'http://www.abc.com'>
    B := A;
    D := AnsiPos('=', B);
    if D = 0 then Exit;
    B := GetText(B);

    if Length(B) = 0 then Exit;
    B := BuildURL(B);
    if AnsiPos('.jpg', lowercase(B)) > 0 then
      begin
        //Simple Pic
        if CanItem(B) then
          if not URLDone(B) then
            lbWork.Items.Add(B);
        Exit;
      end;
    if AnsiPos('.jpe', lowercase(B)) > 0 then
      begin
        //Simple Pic
        if CanItem(B) then
          lbWork.Items.Add(B);
        Exit;
      end;
    if AnsiPos('.img', lowercase(B)) > 0 then
      begin
        //Simple Pic
        if CanItem(B) then
          if not URLDone(B) then
            lbWork.Items.Add(B);
        Exit;
      end;
    if RulesEnforce(ConnectAddress, B) then
      begin
        //Rule says we have to get this
        if CanItem(B) then
          if not URLDone(B) then
            lbWork.Items.Add(B);
        Exit;
      end;
    C := '';
    if AnsiPos('/', B) > 0 then
      C := My_stringToEx(B, '/');
    if ((Length(C) > 0) and (AnsiPos('.', C) > 0)) then
      begin
          if not RulesAllow(ConnectAddress, B) then
            begin
              DoReply('Skipping '  + B + ' by rule', rForMemo);
              Exit;
            end;      
        AddFoundURL(B);
        Exit;
      end;
    if AnsiPos('http://', LowerCase(B)) > 0 then
      begin
          if not RulesAllow(ConnectAddress, B) then
            begin
              DoReply('Skipping '  + B + ' by rule', rForMemo);
              Exit;
            end;
        AddFoundURL(B);
        Exit;
      end;
    if AnsiPos('.', B) > 0 then
      begin
        //Check List of Filetypes to DL
        //Memo1.Lines.Add('****Spotted resource '  + B);
        //Exit;
      end;
    //Skip the following <a href>'s because we don't know
    //how to manage them
    if AnsiPos('mailto:', LowerCase(B)) > 0 then
      Exit;
    if AnsiPos('javascript:', LowerCase(B)) > 0 then
      Exit;
    if AnsiPos('javascript.win', LowerCase(B)) > 0 then
      Exit;
    if My_FileExtension(B) = '.css' then
      Exit;
    //URL in same domain
    if Length(B) > 1 then
      if B[2] = '#' then
        B := '';
    if Length(B) > 0 then
        begin
          if not RulesAllow(ConnectAddress, B) then
            begin
              DoReply('Skipping '  + B + ' by rule', rForMemo);
              Exit;
            end;
          if not URLDone(B) {and RulesAllow(ConnectAddress, B)} then
            begin
              T := CurrentURL;
              T.Link := B;
              lbWork.Items.Add(URLToStr(T));
            end;
          //Memo1.Lines.Add('****Spotted '  + B + ' in ' + ConnectAddress);
        end;
  end;

  procedure ProcessFrame;
  var
    D: Integer;
    B: string;
    T: TURL;
  begin
    B := A;
    D := AnsiPos('src', LowerCase(B));
    B := My_Substring(B, D, -1);
    B := GetText(B);
    if Length(B) > 0 then
      if not URLDone(B) then
        begin
          B := BuildURL(B);
          if not RulesAllow(ConnectAddress, B) then
            begin
              DoReply('Skipping '  + B + ' by rule', rForMemo);
              Exit;
            end;
          if not URLDone(B) then
            begin
              T := CurrentURL;
              T.Link := B;
              AddFoundURL(B);
            end;
        end;
  end;

begin
  //Fetch status code
  Stat := My_Substring(Lc, 1, AnsiPos(#13#10, Lc));
  A := My_stringFromEx(Stat, ' ');
  A := My_stringToEx(A, ' ');
  try
    LastStatus := StrToInt(A);
  except
    On EConvertError do
      LastStatus := 0;
  end;
  A := 'Status Code: ' + IntToStr(LastStatus) + ' ';
  if (LastStatus > 0) and (LastStatus < 300) then
    //OK: Information
    A := ''
  else
    A := A + GetStatusstring(LastStatus);

  if LastStatus = 401 then
    begin
      //Near-future implementation: USER-AUTH
      //URL requires AUTH (user/pass)
      //Need to redo request with proper info

      //Memo1.Lines.Add(Lc);

      //if DLCount < 1 then
      //  Memo1.Lines.Add('AUTH: user/pass required');

      //Sample response from server
      //Status Code: 401Unauthorized
      //HTTP/1.1 401 Authorization Required
      //Date: Sun, 02 Mar 2003 21:27:29 GMT
      //Server: Apache/1.3.27 (Unix) PHP/4.1.2
      //WWW-Authenticate: Basic realm="Members Area"
      //Transfer-Encoding: chunked
      //Content-Type: text/html
      //Connection: close
      //Proxy-Connection: close

      //Exit;
    end;

  lbWork.Items.BeginUpdate;
  FoundURLs.Items.BeginUpdate;

  //A := Lc;
  //Memo1.Lines.Add(Lc);
  //Scan Data for Images
  A := Lc;
  while Length(A) > 0 do
    begin
      A := NextTag('img', A);
      ProcessPic;
    end;

  A := Lc;
  J := 0;
  //Scan Data for URLs
  while Length(A) > 0 do
    begin
      A := NextTag('href', A);
      ProcessURL;
    end;

  A := Lc;
  //Scan Data for Frames
  while Length(A) > 0 do
    begin
      A := NextTag('<frame', A);
      ProcessFrame;
    end;

  if J > 0 then
    Lc := My_Substring(A, J + 4, -1);
  lbWork.Items.EndUpdate;
  FoundURLs.Items.EndUpdate;

  //Make sure any attached clients know about LC
  if Response > 0 then
    begin
      StrLCopy(URLText, PChar(Lc), URLTextLen);
      SendMessage(Response, wm_Control, cm_FinishedURL, 0);
    end;

  DownLoadNextFile;
end;

function InitSockets: Boolean;
var
  I: Integer;
  J: Word;
  WD: TWSAData;
begin
  Result := True;
  //Start up
  GetMem(WD.lpVendorInfo, 255);
  Wd.wVersion := 2;
  Wd.wHighVersion := 0;
  J := MakeWord(1, 1);
  I := WSAStartUp(J, WD);
  if I > 1 then
    begin
      //init failed
      SetErrorText('Initialization failure.');
      Result := False;
    end;
  FreeMem(Wd.lpVendorInfo, 255);
  hSockEvent := WSACreateEvent;
  hLSockEvent := WSACreateEvent;
end;

function IsDot(Address: string): Boolean;
var
  I: Integer;
  A: string;
begin
  Result := False;
  A := '';
  For I := 1 to Length(Address) do
    begin
      if Address[I] = '.' then
        begin
          try
            StrToInt(A);
          except
            On EConvertError do
              Exit;
          end;
          A := '';
        end
      else
        A := A + Address[I];
    end;
  Result := True;
end;

function IsURLDone(B: string): Boolean;
var
  Buffer: array[0..4096] of Char;
  W: DWord;
  D: Integer;
  Total, Max: Integer;
begin
  Result := False;
  if Length(B) < 2 then
    Exit;
  B := LowerCase(B);
  SetFilePointer(hFoundFile, 0, nil, File_Begin);
  Max := GetFileSize(hFoundFile, nil);
  Total := 0;
  while Total < Max do
    begin
      ReadFile(hFoundFile, @D, Sizeof(Integer), @W, nil);
      ReadFile(hFoundFile, @Buffer, D, @W, nil);
      if StrPas(Buffer) = B then
        begin
          Result := True;
          Break;
        end;
      Total := Total + SizeOf(Integer) + D;
    end;
end;

procedure SetErrorText(const R: string);
begin
  EnterCriticalSection(hCriticalSection);
  stErrorText := R;
  LeaveCriticalSection(hCriticalSection);
end;

function SocketThread(Param: Pointer): Integer;
var
  I, J, K: Integer;
  EventList: Array[0..10] of THandle;
  W: DWord;
  R: TWSANetworkEvents;
  A: string;
begin
  Result := 0;
  stErrorText := '';
  stReplyText := '';
  if not InitSockets then
    MustClose := True;

  //Fill the EventList
  EventList[0] := hCloseEvent;
  EventList[1] := hBrowseEvent;
  EventList[2] := hLoadNextEvent;
  EventList[3] := hSockEvent;
  EventList[4] := hLSockEvent;
  EventList[5] := hAbortEvent;
  CurrentTask := wt_None;

  //Main Loop
  while not MustClose do
    begin
      W := WaitForMultipleObjects(6, @EventList, False, Infinite);
      Case W of
        0:
          begin
            Closehandle(Fh);
            CloseSocket(SockHandle);
          end;
        1:
          begin
            BytesLoaded := 0;
            CurrentTask := wt_Resolving;
            DoConnect(True, hSockEvent);
            CurrentTask := wt_Fetching;
          end;
        2:
          begin
            //Load next
            BytesLoaded := 0;
            CurrentTask := wt_Resolving;
            DoConnect(False, hLSockEvent);
            CurrentTask := wt_Fetching;
          end;
        3:
          begin
            WSAEnumNetworkEvents(SockHandle, hSockEvent, @R);
            if (R.lNetworkEvents and FD_Connect) = FD_Connect then
              begin
                //DoReply('Connected');
              end;
            if (R.lNetworkEvents and FD_Read) = FD_Read then
              begin
                J := Recv(SockHandle, InBuf, 255, 0);
                SetLength(A, J);
                For K := 0 to J - 1 do
                  A[K + 1] := InBuf[K];
                Lc := Lc + A;
              end;
            if (R.lNetworkEvents and FD_Write) = FD_Write then
              if Length(SendData) > 0 then
                begin
                  J := Send(SockHandle, PChar(SendData), Length(SendData), 0);
                  if J = -1 then
                    begin
                      DoError('Send Error');
                      SendData := '';
                    end;
                  SendData := Copy(SendData, J, Length(SendData) - J);
                  //DoMessage(IntToStr(J) + ' bytes sent.', False);
              end;
            if (R.lNetworkEvents and FD_Close) = FD_Close then
              begin
                //Browse Complete
                PostMessage(MainForm.Handle, wm_BrowseComplete, 0, 0);
                HTMLLoaded;
              end;
          end;
        4:
          begin
            WSAEnumNetworkEvents(SockHandle, hLSockEvent, @R);
            if (R.lNetworkEvents and FD_Read) = FD_Read then
              begin
                J := Recv(SockHandle, InBuf, 255, 0);
                SetLength(A, J);
                For K := 0 to J - 1 do
                  A[K + 1] := InBuf[K];
                //DoReply(IntToStr(J) + ' bytes received', rForMemo);
                if not CanWrite then
                  begin
                    Fc := Fc + A;
                    if AnsiPos(#13#10#13#10, Fc) > 0 then
                      begin
                        A := My_Substring(Fc, AnsiPos(#13#10#13#10, Fc) + 4, -1);
                        CanWrite := True;
                      end
                    else
                      Continue;
                  end;
                CurrentTask := wt_Fetching;
                WriteFile(Fh, PChar(A), Length(A), @W, nil);
                BytesLoaded := BytesLoaded + J;
              end;
            if (R.lNetworkEvents and FD_Write) = FD_Write then
              if Length(SendData) > 0 then
                begin
                  J := Send(SockHandle, PChar(SendData), Length(SendData), 0);
                  if J = -1 then
                    begin
                      DoError('Send Error');
                      SendData := '';
                    end;
                  SendData := Copy(SendData, J, Length(SendData) - J);
                  //DoMessage(IntToStr(J) + ' bytes sent.', False);
              end;
            if (R.lNetworkEvents and FD_Close) = FD_Close then
              begin
                //dl complete
                if AutoDisplay then
                  begin
                    I := GetFileSize(Fh, nil);
                    if I > MinFileSize then
                      begin
                        Mp^.FileName := DFile;
                        SendMessage(HWND_BroadCast, wm_LoadPic, 0, 0);
                        if (Random(100) < 50) OR (ImageViewer = 0) or not IsWindow(ImageViewer) then
                          begin
                            ImageViewer := FindWindow(nil, 'ImageViewer');
                            if ImageViewer = 0 then
                              ShellExecute(MainForm.Handle, nil,
                                PChar(My_FileDirectory(ParamStr(0)) + 'ImageViewer.exe'),
                                PChar(DFile), nil, sw_ShowNormal);
                          end;
                      end;
                  end;
                I := GetFileSize(Fh, nil);
                Closehandle(Fh);
                CloseSocket(SockHandle);

                J := 0;
                if Response > 0 then
                  J := SendMessage(Response, wm_Control, cm_FinishedDL, 0);
                SendMessage(MainForm.Handle, wm_DownloadComplete, 0, I);
                if (I < MinFileSize) and (J = 0) then
                  DeleteFile(DFile);
                DownLoadNextFile;
              end;
          end;
        5:
          begin
            //Usually called when system has timed-out
            Closehandle(Fh);
            CloseSocket(SockHandle);
            DownLoadNextFile;
          end;
      end;
    end;

  //All Done
  CloseHandle(hSockEvent);
  CloseHandle(hLSockEvent);
  WSACleanUp;
  CloseHandle(hBrowseEvent);
  CloseHandle(hLoadNextEvent);
  CloseHandle(hCloseEvent);
  CloseHandle(hAbortEvent);

end;

procedure StopDownLoad;
begin
  //Close and force out any download in progress
  //Closehandle(Fh);
  //CloseSocket(SockHandle);
  SetEvent(hAbortEvent);
end;

var
  X: Integer;
begin
  InitializeCriticalSection(hCriticalSection);
  hBrowseEvent := CreateEvent(nil, False, False, nil);
  hCloseEvent := CreateEvent(nil, False, False, nil);
  hLoadNextEvent := CreateEvent(nil, False, False, nil);
  hAbortEvent := CreateEvent(nil, False, False, nil);
  {$IFDEF VER100}
  hSockThread := BeginThread(nil, 0, @SocketThread, nil, 0, X);
  {$ELSE}
  IsMultiThread := True;
  hSockThread := CreateThread(nil, 0, @SocketThread, nil, 0, X);
  {$ENDIF}
end.
