unit uRuleWizard;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, CrawlProcs;

type
  TRuleWizard = class(TForm)
    stURL: TLabel;
    edtURL: TEdit;
    stRuleKind: TLabel;
    cbRuleKind: TComboBox;
    stCondition: TLabel;
    edtCondition: TEdit;
    stResult: TLabel;
    cbResult: TComboBox;
    bOk: TButton;
    bCancel: TButton;
    procedure edtURLChange(Sender: TObject);
    procedure cbRuleKindChange(Sender: TObject);
    procedure edtConditionChange(Sender: TObject);
    procedure cbResultChange(Sender: TObject);
  private
    { Private declarations }
    Procedure CheckFinished;
  public
    Function NewRule(URL: String): Boolean;
    Function AsRule: TRule;
  end;

var
  RuleWizard: TRuleWizard;

implementation

{$R *.DFM}

Function TRuleWizard.AsRule: TRule;
var
  R: TRule;
begin
  R.Link := edtURL.Text;
  R.RuleKind := cbRuleKind.ItemIndex;
  R.Condition := edtCondition.Text;
  R.Result1 := cbResult.ItemIndex;
  Result := R;
end;

Procedure TRuleWizard.CheckFinished;
begin
  bOk.Enabled :=
    (Length(edtURL.Text) > 0) AND
    (Length(cbRuleKind.Text) > 0) AND
    (Length(edtCondition.Text) > 0) AND
    (Length(cbResult.Text) > 0);
end;

Function TRuleWizard.NewRule(URL: String): Boolean;
begin
  edtURL.Text := URL;
  cbRuleKind.Text := '';
  edtCondition.Text := '';
  cbResult.Text := '';
  Result :=  ShowModal = mrOk;
end;

procedure TRuleWizard.edtURLChange(Sender: TObject);
begin
  CheckFinished;
end;

procedure TRuleWizard.cbRuleKindChange(Sender: TObject);
begin
  CheckFinished;
end;

procedure TRuleWizard.edtConditionChange(Sender: TObject);
begin
  CheckFinished;
end;

procedure TRuleWizard.cbResultChange(Sender: TObject);
begin
  CheckFinished;
end;

end.
