unit uRuleForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ComCtrls, CrawlProcs, mStrin32, RxRichEd;

type
  TRuleForm = class(TForm)
    Tv: TTreeView;
    Memo: TRxRichEdit;
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TvChange(Sender: TObject; Node: TTreeNode);
    procedure MemoKeyPress(Sender: TObject; var Key: Char);
    procedure MemoProtectChangeEx(Sender: TObject; const Message: TMessage;
      StartPos, EndPos: Integer; var AllowChange: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RuleForm: TRuleForm;
  tvChanging: Boolean;

implementation

{$R *.DFM}

procedure TRuleForm.FormShow(Sender: TObject);
var
  //A: String;
  F: File of TRule;
  R: TRule;
  N: TTreeNode;
  //I: Integer;

  Procedure AddTree(N: TTreeNode; A: String);
  var
    B, C: String;
    I, J: Integer;
  begin
    If Length(A) = 0 then Exit;
    //If A[1] = '.' then
    //  A := My_SubString(A, 2, -1);
    //B := My_StringToEx(A, '.');
    J := 0;
    For I := Length(A) downto 1 do
      If A[I] = '.' then
        begin
          J := I;
          Break;
        end;
    B := My_SubString(A, J + 1, -1);
    For I := 0 to N.Count - 1 do
      If LowerCase(N.Item[I].Text) = LowerCase(B) then
        begin
          C := My_SubString(A, 1, J - 1);
          if AnsiPos('.', C)>0 then
            AddTree(N.Item[I], C);
          Exit;
        end;
    If Length(B) > 0 then
      begin
        N := tv.Items.AddChild(N, B);
        If J > 0 then
          AddTree(N, My_SubString(A, 1, J - 1));
      end;
  end;

begin
  tv.Items.Clear;
  N := TTreeNode.Create(Tv.Items);
  tv.Items.AddFirst(N, '*');
  //Load the Rules
  AssignFile(F, My_FileDirectory(ParamStr(0)) + 'rules.dat');
  {$I-}
  Reset(F);
  If IOResult<>0 then
    Rewrite(F);
  {$I+}
  While not eof (F) do
    begin
      Read(F, R);
      AddTree(tv.Items[0], R.Link);
    end;
  tv.FullExpand;
  CloseFile(F);
end;

procedure TRuleForm.FormCreate(Sender: TObject);
begin
  tv.Align := alLeft;
  Memo.Align := alClient;
  Memo.AutoURLDetect := False;
  tvChanging := False;
end;

procedure TRuleForm.TvChange(Sender: TObject; Node: TTreeNode);
var
  A, B, C: String;
  X: TTreeNode;
  F: File of TRule;
  R: TRule;
begin
  tvChanging := True;
  X := Node;
  A := X.Text;
  If not (X.Parent = nil) then
    While not (X.Parent = tv.Items[0]) do
      begin
        X := X.Parent;
        A := A + '.' + X.Text;
      end;
  Memo.Text := A;
  //Look for rules matching A
  AssignFile(F, My_FileDirectory(ParamStr(0)) + 'rules.dat');
  {$I-}
  Reset(F);
  If IOResult<>0 then
    Rewrite(F);
  {$I+}
  While not eof (F) do
    begin
      Read(F, R);
      If LowerCase(R.Link) = LowerCase(A) then
        begin
          Case R.RuleKind of
            rk_MatchText: B := 'If "' + R.Condition + '" in URL ';
            rk_MatchTextCS: B := 'If "' + R.Condition + '"(case-insensitive) in URL ';
          else
            B := 'If Unknown';
          end;
          B := B + ' then ';
          Case R.Result1 of
            rk_Skip: B := B + 'skip this URL.';
            rk_Get: B := B + 'get this URL.';
          else
            B := 'unknown.';
          end;
          C := IntToStr(FilePos(F) - 1);
          While Length(C) < 4 do
            C := '0' + C;
          B := C + ' ' + B;
          Memo.Lines.Add(B);
          //Memo.SelStart := Length(Memo.Text) - Length(B) - 2;
          Memo.SelStart := Memo.SelStart - Length(B);
          Memo.SelLength := 4;
          Memo.SelAttributes.Color := clBlue;
          Memo.SelAttributes.Protected := True;
        end;
    end;
  Memo.Lines.Add('');
  CloseFile(F);
  If Length(A) > 1 then
    begin
      Memo.SelStart := 0;
      Memo.SelLength := Length(A);
      Memo.SelAttributes.Size := 12;
      Memo.SelAttributes.Protected := True;
      Memo.SelStart := Length(Memo.Text);
    end;
  tvChanging := False;
end;

procedure TRuleForm.MemoKeyPress(Sender: TObject; var Key: Char);
var
  I, C, D: Integer;
  A, S, T, Link: String;
  F: File of TRule;
  R: TRule;
  Found: Boolean;
begin
  if Key = #13 then
    begin
      //Line from Pos?
      I := SendMessage(Memo.Handle, EM_LINEFROMCHAR, Memo.SelStart - 1 , 0);
      If I = 0 then Exit;
      S := Memo.Lines[I];
      Link := LowerCase(Memo.Lines[0]);
      D := AnsiPos(#32, S);
      A := My_SubString(S, 1, D - 1);
      T := My_SubString(S, D + 1, -1);
      try
        C := StrToInt(A);
      except
        On EConvertError do
          C := -1;
      end;
      Found := False;
      //Find C in the file
      AssignFile(F, My_FileDirectory(ParamStr(0)) + 'rules.dat');
      {$I-}
      Reset(F);
      If IOResult<>0 then
        Rewrite(F);
      {$I+}

      If C > -1 then
        begin
          Seek(F, C);
          Read(F, R);
          Found := True;
          If StrToRule(T, R) then
            begin
              Seek(F, C);
              Write(F, R);
              //ShowMessage('Change line ' + R.Condition);
            end;
        end;

      If not Found then
        begin
          R.Link := Memo.Lines[0];
          If StrToRule(S, R) then
            begin
              Seek(F, FileSize(F));
              Write(F, R);
            end;
          //ShowMessage('New rule for ' + link);
        end;
      CloseFile(F);
      //ShowMessage('Change line ' + InttoStr(I));
    end;
end;


procedure TRuleForm.MemoProtectChangeEx(Sender: TObject;
  const Message: TMessage; StartPos, EndPos: Integer;
  var AllowChange: Boolean);
begin
  AllowChange := tvChanging;
end;

end.
