unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Socket, StdCtrls, mStrin32, ExtCtrls, ComCtrls, Menus,
  ShellAPI, ShlObj, uCrawlControls, CrawlProcs, winSockA, uKForm;

type
  TMainForm = class(TForm)
    Memo1: TMemo;
    bStart: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    edtURL: TEdit;
    Label2: TLabel;
    edtDestination: TEdit;
    WebImages: TImageList;
    Splitter2: TSplitter;
    URLMenu: TPopupMenu;
    MoveUp1: TMenuItem;
    MoveDown1: TMenuItem;
    Delete1: TMenuItem;
    bContinue: TButton;
    Panel3: TPanel;
    StopHere1: TMenuItem;
    Splitter3: TSplitter;
    pFoundURLS: TPanel;
    stFoundURLs: TLabel;
    Clear1: TMenuItem;
    N1: TMenuItem;
    New1: TMenuItem;
    Edit1: TMenuItem;
    N2: TMenuItem;
    pWorking: TPanel;
    stWorking: TLabel;
    N3: TMenuItem;
    Save1: TMenuItem;
    Load1: TMenuItem;
    Od: TOpenDialog;
    Sd: TSaveDialog;
    bRules: TButton;
    bAddRule: TButton;
    stTask: TLabel;
    Timer1: TTimer;
    bOptions: TButton;
    Bevel1: TBevel;
    N4: TMenuItem;
    SortAscending1: TMenuItem;
    Open1: TMenuItem;
    RuleOut1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure bStartClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MoveUp1Click(Sender: TObject);
    procedure MoveDown1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure bContinueClick(Sender: TObject);
    procedure URLBoxClick(Sender: TObject);
    procedure StopHere1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure URLMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ListDblCLick(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure bRulesClick(Sender: TObject);
    procedure bAddRuleClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure bOptionsClick(Sender: TObject);
    procedure SortAscending1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure RuleOut1Click(Sender: TObject);
  private
    //Private declarations
    function FormExists(FormName: string): Boolean;
  public
    //Public declarations
    Procedure AddFoundURL(A: string);
    procedure BrowseURL(aURL, aUser, aPass: string);
    //function  BuildURL(FileName: string): string;
    //procedure ConnectTo(Address: string; CType: Integer);
    procedure DisplayError(X: string);
    //Procedure DownloadNextFile;
    procedure ListKeyPress(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Sendstring(S: string);
    Procedure WndProc(var Message: TMessage); override;
  end;

const
  wm_FSock      = wm_User + 23;
  wm_Resolve    = wm_User + 24;
  BufferSize    = Sizeof(TSockBuf);

var
  MainForm: TMainForm;
  Fc: string;
  //Fh: THandle;
  UserBreak, CanWrite: Boolean;
  //URL, Last_Add: string;
  //_Add: string;
  //DFile: string;
  lbWork: TURLBox;
  FoundURLs: TURLBox;
  FoundFileName: string;
  hFoundFile: THandle;
  CurrentURL: TURL;
  dlcount: Integer = 0;
  DownLoadTimeOut: Integer = 60;
  CanTimeOut: Boolean = True;
  SettingsModified: Boolean = False;

implementation

//http://msdn.microsoft.com/library/default.asp?url=/library/en-us/shellcc/platform/shell/programmersguide/shell_basics/shell_basics_programming/transferring/transfer.asp
//RegisterDragDrop

uses uURLForm, uRuleForm, uRuleWizard, uSettingsForm, uSockThread;

{$R *.DFM}

const
  winsocket = 'Ws2_32.dll';

function ReadFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';
function send(s: TSocket; Buf: Pointer; len, flags: Integer): Integer; stdcall; external winsocket;
function WriteFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';

function IsURLDone(B: string): Boolean;
var
  Buffer: Array[0..4096] of Char;
  W: DWord;
  D: Integer;
  Total, Max: Integer;
begin
  Result := False;
  if Length(B) < 2 then
    Exit;
  B := LowerCase(B);
  SetFilePointer(hFoundFile, 0, nil, File_Begin);
  Max := GetFileSize(hFoundFile, nil);
  Total := 0;
  While Total < Max do
    begin
      ReadFile(hFoundFile, @D, Sizeof(Integer), @W, nil);
      ReadFile(hFoundFile, @Buffer, D, @W, nil);
      if StrPas(Buffer) = B then
        begin
          Result := True;
          Break;
        end;
      Total := Total + SizeOf(Integer) + D;
    end;
end;

Procedure TMainForm.AddFoundURL(A: string);
var
  I: Integer;
  T: TURL;
  X: string;
begin
  I := AnsiPos('#', A);
  if I > 0 then
    A := My_Substring(A, 1, I - 1);
  if AnsiPos('mailto:', LowerCase(A)) > 0 then
    Exit;
  if AnsiPos('irc:', LowerCase(A)) > 0 then
    Exit;
  //To check rules: excract URL into X
  X := A;
  if AnsiPos(':', X) > 0 then
    X := My_Substring(X, 8, -1);
  For I := 1 to Length(X) do
    if (X[I] = '/') OR (X[I] = '/') then
      begin
        X := My_Substring(X, 1, I - 1);
        Break;
      end;

  if not RulesAllow(X, A) then
    begin
      Memo1.Lines.Add('Skipping '  + A + ' by rule');
      Exit;
    end;
  if not FoundURLS.LookFor(A) then
    if not IsURLDone(A) then
      begin
        T := CurrentURL;
        T.Link := A;
        T.Level := T.Level + 1;
        if ((MaxLevel > -1) AND (T.Level <= MaxLevel)) OR
           (MaxLevel = -1) then
          FoundURLS.Items.Add(URLToStr(T));
      end;
end;

function TMainForm.FormExists(FormName: string): Boolean;
var
  I: Integer;
begin
  Result := False;
  For I := 0 to Screen.FormCount - 1 do
    if UpperCase(Screen.Forms[I].Name) = UpperCase(FormName) then
      begin
        Result := True;
        Break;
      end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  A: string;
  I: Integer;
  Cs: array[0..512] of char;
  X: PItemIDList;
  F: TextFile;
begin
  edtURL.hint :=
    'www.site.com' + #13#10 +
    'or'#13#10 +
    '"www.site.com",MaxLevel';

  //Position the components manually because
  //it's easier to design events when you can
  //click them. When they overlap at design-time
  //it becomes difficult
  Splitter2.Align := alRight;

  //Working Panel
  Panel3.Caption := '';
  Panel3.Align := alRight;
  Panel3.BevelOuter := bvNone;
  Panel3.Width := ClientWidth div 2;

  pWorking.BevelOuter := bvNone;
  pWorking.Align := alTop;
  pWorking.Height := Panel3.ClientHeight div 2;

  stWorking.Align := alTop;
  lbWork := TURLBox.Create(Self);
  lbWork.Name := 'lbWork';
  lbWork.Parent := pWorking;
  lbWork.Align := alClient;
  lbWork.BorderStyle := bsNone;
  lbWork.PopUpMenu := URLMenu;
  lbWork.Font.Size := 10;
  lbWork.OnClick := URLBoxClick;
  lbWork.OnDblClick := ListDblClick;
  lbWork.OnMouseMove := URLMouseMove;
  lbWork.OnKeyDown := ListKeyPress;
  //lbWork.ShowHint := True;

  Splitter3.Align := alTop;
  Splitter3.Color := clWindow;

  pFoundURLs.BevelOuter := bvNone;
  pFoundURLs.Align := alClient;
  stFoundURLS.align := alTop;

  FoundURLS := TURLBox.Create(Self);
  FoundURLS.Name := 'FoundURLS';
  FoundURLS.Parent := pFoundURLs;
  FoundURLS.Align := alClient;
  FoundURLS.BorderStyle := bsNone;
  FoundURLS.PopUpMenu := URLMenu;
  FoundURLS.Font.Size := 10;
  FoundURLS.OnClick := URLBoxClick;
  FoundURLS.OnDblClick := ListDblClick;
  FoundURLS.OnMouseMove := URLMouseMove;
  FoundURLS.OnKeyDown := ListKeyPress;
  //FoundURLS.ShowHint := True;

  Panel1.align := alTop;
  Memo1.align := alClient;

  Response := 0;

  if ParamCount > 0 then
    begin
      A := '';
      For I := 1 to ParamCount do
        A := A + ParamStr(I) + ' ';
      A := My_Substring(A, 1, Length(A) - 1);
      //Check for other params
      edtURL.Text := A;
      PostMessage(Handle, wm_Start, 0, 0);
    end;

  //Need Found-file name
  GetTempPath(512, Cs);
  GetTempFileName(Cs, 'web', 0, Cs);
  FoundFileName := StrPas(Cs);
  //Open the file of FoundURLs for the duration of the session
  hFoundFile := CreateFile(PChar(FoundFileName),
    Generic_Read OR Generic_Write,
    File_Share_Read OR File_Share_Write, nil, Create_Always, 0, 0);
  //Set up the receiving directory to default my_documents and then
  //try to read file if it exists
  SHGetSpecialFolderLocation(Handle, CSIDL_PERSONAL, X);
  SHGetPathFromIDList(X, Cs);
  A := StrPas(Cs);
  AssignFile(F, My_FileDirectory(ParamStr(0)) + 'Settings.ini');
  {$I-}
  Reset(F);
  if IOResult = 0 then
    begin
      Readln(F, A);
      A := My_stringFromEx(A, '=');
      edtDestination.Text := A;
      Readln(F, A);
      A := My_stringFromEx(A, '=');
      CanTimeOut := (LowerCase(A) = 'true') OR (LowerCase(A) = 'yes');
      Readln(F, A);
      A := My_stringFromEx(A, '=');
      try
        DownLoadTimeOut := StrToInt(A);
      except
        On EConvertError do
          begin end;
      end;
      Readln(F, A);
      A := My_stringFromEx(A, '=');
      AutoDisplay := (LowerCase(A) = 'true') OR (LowerCase(A) = 'yes');
      if not eof(F) then
        begin
          Readln(F, A);
          A := My_stringFromEx(A, '=');
          try
            MinFileSize := StrToInt(A);
          except
            On EConvertError do
              begin end;
          end;
        end;
    end;
  CloseFile(F);
  {$I+}
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  F: TextFile;
begin
  CloseSockets;
  CloseHandle(hFoundFile);
  DeleteFile(FoundFileName);
  if edtDestination.Modified OR SettingsModified then
    begin
      AssignFile(F, My_FileDirectory(ParamStr(0)) + 'Settings.ini');
      {$I-}
      Rewrite(F);
      Writeln(F, 'PicDir=' + edtDestination.Text);
      if CanTimeOut then
        Writeln(F, 'CanTimeOut=True')
      else
        Writeln(F, 'CanTimeOut=False');
      Writeln(F, 'DownLoadTimeOut=' + IntToStr(DownLoadTimeOut));
      if AutoDisplay then
        Writeln(F, 'AutoDisplay=True')
      else
        Writeln(F, 'AutoDisplay=False');
      Writeln(F, 'MinimumFileSize=' + IntToStr(MinFIleSize));
      CloseFile(F);
      {$I+}
      edtDestination.Modified := False;
    end;
end;

procedure TMainForm.bStartClick(Sender: TObject);
var
  A, U: string;
  I: Integer;
begin
  if bStart.Caption = 'Start!' then
    begin
      //
      Timer1.Enabled := True;
      bStart.Caption := 'Stop!';
      dlCount := 0;
      MaxLevel := -1;
      A := edtURL.Text;
      if Length(A) = 0 then
        begin
          UserBreak := False;
          DownLoadNextFile;
          Exit;
        end;
      I := AnsiPos('"', A);
      if I > 0 then
        begin
          A := My_Substring(A, I + 1, -1);
          I := AnsiPos('"', A);
          U := '';
          if I > 0 then
            U := My_Substring(A, I + 1, -1);
          //Reduce A
          A := My_Substring(A, 1, I - 1);
          //Look for the numbers in U
          For I := 1 to Length(U) do
            if (U[I] >= '0') AND (U[I] <= '9') then
              begin
                U := My_Substring(U, I, -1);
                try
                  MaxLevel := StrToInt(U);
                except
                  On EConvertError do
                    begin end;
                end;
              end;
        end
      else
        if (A[Length(A)] >= '0') AND (A[Length(A)] <= '9') then
        begin
          //Scroll backwards looking for ### and break
          For I := Length(A) downto 1 do
            if (A[I] < '0') OR (A[I] > '9') then
              begin
                U := My_Substring(A, I + 1, -1);
                A := My_Substring(A, 1, I - 1);
                try
                  MaxLevel := StrToInt(U);
                except
                  On EConvertError do
                    begin end;
                end;
                Break;
              end;
        end;
      BrowseURL(A, '', '');
      UserBreak := False;
      Exit;
    end;
  if bStart.Caption = 'Stop!' then
    begin
      UserBreak := True;
      bStart.Caption := 'Start!';
    end;
end;

procedure TMainForm.DisplayError(X: string);
begin
  Memo1.Lines.Add(X);
end;

procedure TMainForm.Sendstring(S: string);
begin
end;

procedure TMainForm.BrowseURL(aURL, aUser, aPass: string);
begin
   if MaxLevel > -1 then
    if CurrentURL.Level > MaxLevel then
      begin
        Memo1.Lines.Add('Crawl terminated. Maximum level reached');
        Exit;
      end;
  Destination := edtDestination.Text;
  if not (Destination[Length(Destination)] = '\') then
    Destination := Destination + '\';

  uSockThread.BrowseURL(aURL, aUser, aPass);
end;

Procedure TMainForm.WndProc(var Message: TMessage);
var
  I: Integer;
  A: string;
  T: TURL;
begin
  Inherited WndProc(Message);
  if Message.Msg = wm_Start then
    bStartClick(Self);
  if Message.Msg = wm_Control then
    begin
      Case Message.WParam of
        cm_Browse:
          begin
          if bStart.Caption = 'Start!' then
            begin
              bStart.Caption := 'Stop!';
              dlCount := 0;
              //We have to assume this client wants to blantantly
              //kill whatever is currently going on
              FoundURLS.Clear;
              //Browse immediately
              MaxLevel := 0;
              BrowseURL(MP^.WebSite, '', '');
            end
          else
            begin
              T.Link := MP^.WebSite;
              T.Level := 00;
              AddFoundURL(URLToStr(T));
              //Multiple download don't work
              //To STOP we'll trust the existing MaxLevel

              //bContinue.Visible := False;
              //bStart.Caption := 'Stop!';
              //UserBreak := False;
              //DownLoadNextFile;}
              //AddFoundURL('STOP');
              end;
            Response := Message.lParam;
          end;
        cm_Clear:
          FoundURLS.Clear;
        cm_Respond:
          Message.Result := Handle;
      end;
    end;
  Case Message.Msg of
    wm_BrowseComplete:
      begin
        //HTMLLoaded;
      end;
    wm_Break:
      begin
        if (lbWork.Items.Count > 0) OR (FoundURLS.Items.Count > 0) then
          bContinue.Visible := True;
        bStart.Caption := 'Start!';
        Memo1.Lines.Add('User break');
        Timer1.Enabled := False;
        stTask.Caption := '';
      end;
    wm_Finished:
      begin
        Memo1.Lines.Add('Finished');
        bStart.Caption := 'Start!';
      end;
    wm_Reply:
      begin
        A := GetReply(rNone);
        if (Length(Memo1.Text) > 40000) OR (Memo1.Lines.Count > 100) then
          Memo1.Lines.Clear;
        if Length(A) > 0 then
          Memo1.Lines.Add(A);
      end;
    wm_DownLoadComplete:
      begin
        A := Memo1.Lines[Memo1.Lines.Count - 1];
        I := Message.lParam;
        if I > 0 then
          A := A + ' (' + IntToStr(I) + ' bytes)';
        if (I = 0) OR (LastStatus >= 300) then
          A := A + ' [' + GetStatusstring(LastStatus) + ']';
        Memo1.Lines.Delete(Memo1.Lines.Count - 1);
        Memo1.Lines.Add(A);
      end;
  end;
end;

var
  Fi: TListBox = nil;

procedure TMainForm.MoveUp1Click(Sender: TObject);
var
  I: Integer;
begin
  if Fi = nil then Exit;
  For I := 1 to Fi.Items.Count - 1 do
    if Fi.Selected[I] then
      Fi.Items.Exchange(I, I - 1);
end;

procedure TMainForm.MoveDown1Click(Sender: TObject);
var
  I: Integer;
begin
  if Fi = nil then Exit;
  For I := 0 to Fi.Items.Count - 2 do
    if Fi.Selected[I] then
      Fi.Items.Exchange(I, I + 1);
end;

procedure TMainForm.Delete1Click(Sender: TObject);
var
  I: Integer;
begin
  if Fi = nil then Exit;
  For I := Fi.Items.Count - 1 downto 0 do
    if Fi.Selected[I] then
      Fi.Items.Delete(I);
end;

procedure TMainForm.StopHere1Click(Sender: TObject);
var
  I: Integer;
  Found: Boolean;
begin
  if Fi = nil then Exit;
  Found := False;
  For I := Fi.Items.Count - 1 downto 0 do
    if Fi.Selected[I] then
      begin
        Fi.Items.Insert(I, 'STOP');
        Found := True;
        Break;
      end;
  if not Found then
    Fi.Items.Add('STOP');
end;

procedure TMainForm.SortAscending1Click(Sender: TObject);
begin
  if Fi = nil then Exit;
  Fi.Sorted := True;
  Fi.Sorted := False;
end;

procedure TMainForm.ListKeyPress(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Fi := TListBox(Sender);
  Case Key of
    vk_Delete, 8: Delete1Click(Sender);
    27: StopHere1Click(Sender);
    32: Open1Click(Sender);
  end;
end;

procedure TMainForm.bContinueClick(Sender: TObject);
begin
  bContinue.Visible := False;
  bStart.Caption := 'Stop!';
  Timer1.Enabled := True;
  UserBreak := False;
  DownLoadNextFile;
end;

procedure TMainForm.URLBoxClick(Sender: TObject);
begin
  Fi := TListBox(Sender);
end;


procedure TMainForm.Clear1Click(Sender: TObject);
begin
  if Fi = nil then Exit;
  Fi.Items.Clear;
end;

procedure TMainForm.New1Click(Sender: TObject);
var
  T: TURL;
begin
  //New
  if Fi = nil then Exit;
  T.Link := '';
  T.Level := 0;
  T.User := '';
  T.Pass := '';
  if URLForm.Check(T) then
    Fi.Items.Add(URLToStr(T));
end;

procedure TMainForm.Edit1Click(Sender: TObject);
var
  I: Integer;
  T: TURL;
begin
  //Edit
  if Fi = nil then Exit;
  For I := 0 to Fi.Items.Count - 1 do
    if Fi.Selected[I] then
      begin
        T := StrToURL(Fi.Items[I]);
        if URLForm.Check(T) then
          Fi.Items[I] := URLToStr(T);
        Break;
      end;
end;

procedure TMainForm.URLMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  Fi := TListBox(Sender);
end;

procedure TMainForm.ListDblCLick(Sender: TObject);
begin
  Edit1Click(Sender);
end;

procedure TMainForm.Save1Click(Sender: TObject);
begin
  if Fi = nil then Exit;
  if Sd.Execute then
    Fi.Items.SaveToFile(Sd.FileName);
end;

procedure TMainForm.Load1Click(Sender: TObject);
begin
  if Fi = nil then Exit;
  if Od.Execute then
    Fi.Items.LoadFromFile(Od.FileName);
end;

procedure TMainForm.Open1Click(Sender: TObject);
var
  I: Integer;
  T: TURL;
  A: string;
begin
  //Open in Explorer
  if Fi = nil then Exit;
  For I := 0 to Fi.Items.Count - 1 do
    if Fi.Selected[I] then
      begin
        T := StrToURL(Fi.Items[I]);
        A := T.Link;
        if Length(A) = 0 then
          Exit;
        if LowerCase(A) = 'stop' then
          Exit;
        ShellExecute(0, nil, PChar(A), nil, nil, 0);
        Break;
      end;
end;

procedure TMainForm.RuleOut1Click(Sender: TObject);
var
  A: string;
  F: File of TRule;
  R: TRule;
  I: Integer;
  T: TURL;
begin
  if Fi = nil then Exit;

  //Prep Connect Address
  A := ConnectAddress;
  if Length(A) = 0 then
    A := edtURL.Text;
  //Open Rule file
  AssignFile(F, My_FileDirectory(ParamStr(0)) + 'rules.dat');
  {$I-}
  Reset(F);
  if IOResult<>0 then
    Rewrite(F);
  {$I+}
  Seek(F, FileSize(F));

  R.Link := A;
  R.RuleKind := 0;
  R.RuleKind2 := 0;
  R.Result1 := 0;
  For I := Fi.Items.Count - 1 downto 0 do
    if Fi.Selected[I] then
      begin
        T := StrToURL(Fi.Items[I]);
        R.Condition := T.Link;
        Write(F, R);
        Fi.Items.Delete(I);
      end;

  CloseFile(F);
end;

procedure TMainForm.bRulesClick(Sender: TObject);
begin
  RuleForm.Show;
end;

procedure TMainForm.bAddRuleClick(Sender: TObject);
var
  A: string;
  F: File of TRule;
  R: TRule;
begin
  A := ConnectAddress;
  if Length(A) = 0 then
    A := edtURL.Text;
  if RuleWizard.NewRule(A) then
    begin
      R := RuleWizard.AsRule;
      AssignFile(F, My_FileDirectory(ParamStr(0)) + 'rules.dat');
      {$I-}
      Reset(F);
      if IOResult<>0 then
        Rewrite(F);
      {$I+}
      Seek(F, FileSize(F));
      Write(F, R);
      CloseFile(F);
    end;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
var
  A: string;
  T: Integer;
begin
  Case CurrentTask of
    wt_None:
      stTask.Visible := False;
    wt_Resolving:
      begin
        Inc(Count);
        T := Count div 4;
        stTask.Visible := True;
        //stTask.Caption := 'Looking up ' + CurrentURL.Link + ': ' +
        stTask.Caption := 'Looking up ' + ConnectAddress + ': ' +
          IntToStr(T) + 's.';
        if Count > 25 then
          begin
            //Resolution is taking too long
            //A := Memo1.Lines[Memo1.Lines.Count - 1];
            //A := A + ' (Failed: Resolution time-out)';
            //Memo1.Lines.Delete(Memo1.Lines.Count - 1);
            //Memo1.Lines.Add(A);
            Count := 0;
            Memo1.Lines.Add('Error resolving ' + ConnectAddress);
            StopDownLoad;
            //DownLoadNextFile;
          end;
      end;
    wt_Fetching:
      begin
        stTask.Visible := True;
        Inc(Count);
        T := Count div 4;
        stTask.Caption := 'Loading: ' +
          IntToStr(T) + 's, ' +
          IntToStr(BytesLoaded) + ' bytes.';
        if CanTimeOut AND (T > DownLoadTimeOut) then
          begin
            //Load is taking too long
            A := Memo1.Lines[Memo1.Lines.Count - 1];
            A := A + ' (Failed: Time-Out)';
            //DownLoadNextFile;
            StopDownLoad;
          end;
      end;
  end;
end;

procedure TMainForm.bOptionsClick(Sender: TObject);
begin
  if not FormExists('SettingsForm') then
    SettingsForm := TSettingsForm.Create(Self);
  SettingsForm.cbAllowTimeOut.Checked := CanTimeOut;
  SettingsForm.edtTimeOut.Text := IntToStr(DownLoadTimeOut);
  SettingsForm.cbAutoDisplay.Checked := AutoDisplay;
  SettingsForm.edtMinFileSize.Text := IntTostr(MinFileSize);
  if SettingsForm.ShowModal = mrOk then
    begin
      CanTimeOut := SettingsForm.cbAllowTimeOut.Checked;
      try
        DownLoadTimeOut := StrToInt(SettingsForm.edtTimeOut.Text)
      except
        On EConvertError do
          begin
          end;
      end;
      AutoDisplay := SettingsForm.cbAutoDisplay.Checked;
      try
        MinFileSize := StrToInt(SettingsForm.edtMinFileSize.Text)
      except
        On EConvertError do
          begin
          end;
      end;
      SettingsModified := True;
    end;
end;

end.
