unit uCrawlControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, mStrin32, ExtCtrls, ComCtrls, Menus,
  CrawlProcs;

type
  TURLBox=class(TCustomListBox)
    private
      BlueBrush: THandle;
      LastHover: Integer;
    public
      constructor Create(AOwner: TComponent); override;
      destructor Destroy; override;
      procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
      function LookFor(aURL: string): Boolean;
      function URL(Index: Integer): string;
      procedure WndProc(var Message: TMessage); override;
      property BorderStyle;
      property Font;
      property PopupMenu;
      property OnClick;
      property OnDblClick;
      property OnKeyDown;
      property OnMouseMove;
  end;

implementation

constructor TURLBox.Create(AOwner: TComponent);
begin
  Inherited Create(AOwner);
  ItemHeight := 20;
  Font.Size := 20;
  Style := lbOwnerDrawFixed;
  MultiSelect := True;
  BlueBrush := CreateSolidBrush(clBlue);
  ShowHint := True;
  LastHover := -1;
end;

destructor TURLBox.Destroy;
begin
  inherited Destroy;
  DeleteObject(BlueBrush);
end;

procedure TURLBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Dc: THandle;
  A, L: String;
  I: integer;
begin
  DC := GetDC(Handle);

  //BackGround
  If odSelected in State then
    begin
      SelectObject(Dc, BlueBrush);
      SelectObject(Dc, GetStockObject(Null_Pen));
      Rectangle(Dc, Rect.Left, Rect.Top, Rect.Right, Rect.Bottom + 1);
      SetTextColor(DC, clWhite);
    end
  else
    begin
      SelectObject(Dc, GetStockObject(White_Brush));
      SelectObject(Dc, GetStockObject(Null_Pen));
      Rectangle(Dc, Rect.Left, Rect.Top, Rect.Right, Rect.Bottom + 1);
    end;

  A := Items[Index];
  I := AnsiPos(#1, A);
  If I > 0 then
    begin
      L := My_SubString(A, I + 1, -1);
      L := My_StringToEx(L, #1);
      A := My_SubString(A, 1, I - 1);
      If not (L = '0') then
        A := A + ' (' + L + ')';
    end;
  SetBkMode(Dc, Transparent);
  SelectObject(Dc, Font.Handle);
  TextOut(DC, Rect.Left + 2, Rect.Top + 2, PChar(A), Length(A));
  ReleaseDC(Handle, DC);
end;

function TURLBox.LookFor(aURL: string): Boolean;
var
  I: Integer;
begin
  Result := False;
  aURL := LowerCase(aURL);
  for I := 0 to Items.COunt - 1 do
    if LowerCase(URL(I)) = aURL then
      begin
        Result := True;
        Break;
      end;
end;

function TURLBox.URL(Index: Integer): string;
var
  T: TURL;
begin
  T := StrToURL(Items[Index]);
  Result := T.Link;
end;

procedure TURLBox.WndProc(var Message: TMessage);
var
  Pt: TPoint;
  I: Integer;
  T: TURL;
  A: String;
begin
  inherited WndProc(Message);
  if Message.Msg = wm_MouseMove then
    begin
      GetCursorPos(Pt);
      Pt := ScreenToClient(Pt);
      I := ItemAtPos(Pt, True);
      if not (I = LastHover) then
        begin
          LastHover := I;
          If LastHover = -1 then
            Hint := ''
          else
            begin
              T := StrToURL(Items[LastHover]);
              A := T.Link;
              If LowerCase(A) = 'stop' then
                Hint := 'Stop processing at this point'
              else
                begin
                  if T.Level > 0 then
                    A := A + #13 + 'Level: ' + IntTOStr(T.Level);
                  Hint := A;
                end;
            end;
        end;
    end;
end;

end.
