unit uSettingsForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls, mStrin32;

type
  TSettingsForm = class(TForm)
    rOrder: TRadioGroup;
    stDelay: TLabel;
    stMinDimensions: TLabel;
    edtDelay: TEdit;
    Label1: TLabel;
    bOk: TButton;
    StatusBar1: TStatusBar;
    stNext: TLabel;
    edtNext: TEdit;
    stSlower: TLabel;
    edtSlower: TEdit;
    stFaster: TLabel;
    edtFaster: TEdit;
    Label2: TLabel;
    FileTypes: TMemo;
    cbRepeat: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    Function StrToChar(A: String): Char;
  public
    Function NextChar: Char;
    Function FasterChar: Char;
    Function SlowerChar: Char;
  end;

var
  SettingsForm: TSettingsForm;

implementation

uses uMainForm;

{$R *.DFM}

Function TSettingsForm.StrToChar(A: String): Char;
var
  R: Char;
begin
  R := #0;
  If Length(A) > 0 then
    R := A[1];
  If A = '<Space>' then
    R := #32;
  If A = '<ESC>' then
    R := #27;
  If A = '<Ctrl>' then
    R := #1;
  If A = '<Shift>' then
    R := #2;
  If A = '<Alt>' then
    R := #3;
  If A = '<Tab>' then
    R := #4;
  Result := R;
end;

Function TSettingsForm.NextChar: Char;
begin
  Result := StrToChar(edtNext.Text);
end;

Function TSettingsForm.FasterChar: Char;
begin
  Result := StrToChar(edtFaster.Text);
end;

Function TSettingsForm.SlowerChar: Char;
begin
  Result := StrToChar(edtSlower.Text);
end;

procedure TSettingsForm.FormCreate(Sender: TObject);
begin
  Mainform.FileTypes := FileTypes.Lines;
  try
    FileTypes.Lines.LoadFromFile(My_FileDirectory(ParamStr(0)) + 'FileTypes.dat');
  except
    On Exception do
      begin end;
  end;
end;

procedure TSettingsForm.FormKeyPress(Sender: TObject; var Key: Char);
var
  A: String;
begin
  If ActiveControl.Tag = 1 then
    begin
      A := '';
      Case Key of
        #32: A := '<Space>';
        #27: A := '<ESC>';
      end;
      If Length(A) > 0 then
        begin
          Key := #0;
          TEdit(ActiveControl).Text := A;
        end;
      TEdit(ActiveControl).SelectAll;
    end;
  If Key = #27 then
    ModalResult := mrCancel;
end;

procedure TSettingsForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  A: String;
begin
  If ActiveControl.Tag = 1 then
    begin
      A := '';
      If ssCtrl in Shift then
        A := '<Ctrl>';
      If ssShift in Shift then
        A := '<Shift>';
      If ssAlt in Shift then
        A := '<Alt>';
      If Key = vk_Tab then
        A := '<Tab>';
      If Length(A) > 0 then
        TEdit(ActiveControl).Text := A;
      TEdit(ActiveControl).SelectAll;
    end;
end;

procedure TSettingsForm.FormDestroy(Sender: TObject);
begin
  FileTypes.Lines.SaveToFile(My_FileDirectory(ParamStr(0)) + 'FileTypes.dat');
end;

end.
