unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, JPEG, ExtCtrls, mStrin32,
  StdCtrls, ShellAPI, Menus, CrawlProcs;

type
  TDisplayOrder =
    (do_AsSeen, do_Alphabetically, do_NewestFirst, do_Random);
  TMainForm = class(TForm)
    Img: TImage;
    Timer1: TTimer;
    Memo1: TMemo;
    PopupMenu1: TPopupMenu;
    Settings1: TMenuItem;
    mClear: TMenuItem;
    mFullScreen: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Settings1Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure mClearClick(Sender: TObject);
    procedure mFullScreenClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    DisplayOrder: TDisplayOrder;
    FileList: TStringList;
    LastFileName: String;
    Repeats: Boolean;
    DoneList: TStringList;
  public
    { Public declarations }
    FileTypes: TStrings;
    Procedure LoadFile(FileName: String);
    Procedure ParseFile(FileName: String);
    Procedure WndProc(var Message: TMessage); override;
  end;

var
  MainForm: TMainForm;
  NextChar, FasterChar, SlowerChar: Char;

implementation

uses uSettingsForm;

{$R *.DFM}

Procedure TMainForm.LoadFile(FileName: String);
var
  P: Real;
  Found: Boolean;
  A: String;
  I: Integer;
begin
  Found := False;
  A := LowerCase(FileName);
  If FileTypes = nil then
    begin
      If AnsiPos('jpg', A) > 0 then
        Found := True;
    end
  else
    begin
      For I := 0 to FileTypes.Count - 1 do
        If AnsiPos(LowerCase(FileTypes[I]), A) > 0 then
          Found := True;
    end;
  If not Found then
    Exit;
  Caption := 'Image Viewer ' + FileName;
  try
    Img.Picture.LoadFromFile(FileName);
  except
    On Exception do
      Exit;
  end;
  LastFileName := FileName;
  If Repeats then
    DoneList.Add(FileName);
  Img.AutoSize := True;
  If Img.Height >= ClientHeight div 2 then
    begin
      Img.AutoSize := False;
      P := ClientHeight / Img.Height;
      Img.Height := Round(Img.Height * P);
      Img.Width := Round(Img.Width * P);
      Img.Stretch := True;
    end;
  If Img.Height < ClientHeight div 2 then
    begin
      Img.AutoSize := False;
      Img.Height := Img.Height * 2;
      Img.Width := Img.Width * 2;
      Img.Stretch := True;
    end;
end;

Procedure TMainForm.ParseFile(FileName: String);
var
  Found: Integer;
  SearchRec: TSearchRec;
begin
  Found := FindFirst(FileName + '\*.*', faAnyFile, SearchRec);
  while Found = 0 do
    begin
      If SearchRec.Attr = faDirectory then
        begin
          If (Length(SearchRec.Name) > 0) AND NOT (SearchRec.Name[1] = '.') then
            ParseFile(FileName + '\' + SearchRec.Name);
        end
      else
        FileList.Add(FileName + '\' + SearchRec.Name);
      Found := FindNext(SearchRec);
    end;
  FindClose(SearchRec);
end;

Procedure TMainForm.WndProc(var Message: TMessage);
var
  Cs: Array [0..256] of Char;
  I, J: Integer;
  SearchRec: TSearchRec;
  A: String;
begin
  Inherited WndProc(Message);
  Case Message.Msg of
    wm_DropFiles:
      begin
        J := DragQueryFile(Message.wParam, $FFFFFFFF, Cs, 255);
        For I := 0 to J - 1 do
          begin
            DragQueryFile(Message.wParam, I, Cs, 255);
            A := StrPas(Cs);
            FindFirst(A, faAnyFile, SearchRec);
            If SearchRec.Attr = faDirectory then
              ParseFile(A)
            else
              FileList.Add(A);
            FindClose(SearchRec);
          end;
        If not Timer1.Enabled then
          begin
            LoadFile(FileList[0]);
            FileList.Delete(0);
          end;
        If J > 0 then
          Timer1.Enabled := True;
        DragFinish(Message.wParam);
      end;
  end;
  If Message.Msg = wm_LoadPic then
    begin
      try
        Message.Result := 1;
        If Length(MP^.FileName) > 400 then
          Exit;
        FileList.Add(Mp^.FileName);
        If not Timer1.Enabled then
          begin
            LoadFile(FileList[0]);
            FileList.Delete(0);
          end;        
        Timer1.Enabled := True;
      except
        On Exception do
          begin end;
      end;
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  I: Integer;
  A: String;
begin
  DisplayOrder := do_AsSeen;
  FileList := TStringList.Create;
  FileTypes := nil;
  DragAcceptFiles(Handle, True);

  DoneList := TStringList.Create;

  NextChar := #32;
  FasterChar := '+';
  SlowerChar := '-';

  A := '';
  For I := 1 to ParamCount do
    A := A + ParamStr(I) + ' ';
  A := My_SubString(A, 1, Length(A) - 1);
  If ParamCount > 0 then
    LoadFile(A);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FileList.Free;
  DoneList.Free;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  If Repeats AND (FileList.Count = 0) then
    begin
      FileList.Text := DoneList.Text;
      DoneList.Clear;
    end;
  If FileList.Count > 0 then
    begin
      LoadFile(FileList[0]);
      FileList.Delete(0);
    end;
end;

procedure TMainForm.Settings1Click(Sender: TObject);
begin
  SettingsForm.edtDelay.Text := FloatToStr(Timer1.Interval / 1000);
  SettingsForm.rOrder.ItemIndex := Ord(DisplayOrder);
  If SettingsForm.ShowModal = mrOk then
    begin
      try
        Timer1.Interval := Round(StrToFloat(SettingsForm.edtDelay.Text) * 1000);
      except
        On EConvertError do
          begin
          end;
      end;
      DisplayOrder := TDisplayOrder(SettingsForm.rOrder);
      NextChar := SettingsForm.NextChar;
      FasterChar := SettingsForm.FasterChar;
      SlowerChar := SettingsForm.SlowerChar;
      Repeats := SettingsForm.cbRepeat.Checked;
      If not Repeats then
        DoneList.Clear;
    end;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  A: Char;
begin
  A := chr(Key);
  If ssCtrl in Shift then
    A := #1;
  If ssShift in Shift then
    A := #2;
  If ssAlt in Shift then
    A := #3;
  If Key = vk_Tab then
    A := #4;
  If LowerCase(A) = LowerCase(NextChar) then
    begin
      Timer1Timer(Sender);
      Timer1.Enabled := False;
      Timer1.Enabled := True;
    end;
  If (LowerCase(A) = LowerCase(FasterChar)) OR (Key = vk_Add) then
    begin
      If Timer1.Interval >= 1000 then
        Timer1.Interval := Timer1.Interval - 1000
      else
        Timer1.Interval := Timer1.Interval - 100;
      If Timer1.Interval < 500 then
        Timer1.Interval := 500;
    end;
  If (LowerCase(A) = LowerCase(SlowerChar)) OR (Key = vk_Subtract) then
    begin
      If Timer1.Interval < 1000 then
        Timer1.Interval := Timer1.Interval + 100
      else
        Timer1.Interval := Timer1.Interval + 1000;
    end;
end;

procedure TMainForm.mClearClick(Sender: TObject);
begin
  DoneList.Clear;
  FileList.Clear;
end;

procedure TMainForm.mFullScreenClick(Sender: TObject);
var
   r : TRect;
begin
  mFullScreen.Checked := not mFullScreen.Checked;
  If mFullScreen.Checked then
    begin
      Borderstyle := bsNone;
      SetBounds(0, 0, Screen.Width, Screen.Height);
      DragAcceptFiles(Handle, True);
    end
  else
    begin
      Borderstyle := bsSingle;
      SystemParametersInfo(SPI_GETWORKAREA, 0, @r,0) ;
      SetBounds(r.Left, r.Top, r.Right-r.Left, r.Bottom-r.Top) ;
      DragAcceptFiles(Handle, True);
    end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
   r : TRect;
begin
  If mFullScreen.Checked then
    begin
      Borderstyle := bsSingle;
      SystemParametersInfo(SPI_GETWORKAREA, 0, @r,0) ;
      SetBounds(r.Left, r.Top, r.Right-r.Left, r.Bottom-r.Top) ;
    end;
end;

end.
