unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellAPI, CrawlProcs;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    edtURL: TEdit;
    bOk: TButton;
    Memo1: TMemo;
    procedure bOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure WndProc(var Message: TMessage); override;
  end;

var
  Form1: TForm1;
  Wc: THandle;

implementation

{$R *.DFM}

procedure TForm1.bOkClick(Sender: TObject);
begin
  //Load URL into the transfer variable
  MP^.WebSite := edtURL.Text;
  //Make sure Instance of WebCrawler Exists
  If Wc = 0 then
    begin
      //Try to find existing WebCrawler Window
      Wc := FindWindow(nil, 'WebCrawler RE');
      If Wc = 0 then
        begin
          ShellExecute(0, nil, 'WebCrawler.exe', nil, nil, sw_ShowNormal);
          Wc := FindWindow(nil, 'WebCrawler RE');
        end;
      //Hide it?
      ShowWindow(Wc, sw_Hide);
    end;
  //Tell the WebCrawler to go to the URL
  SendMessage(Wc, wm_Control, cm_Browse, Handle);

  {!! System can't sequence multiple downloads yet.
  Can't figure a good method to make it stop
  Stopping is not really a part of WebCrawler's design

  Mp^.WebSite := 'www.altavista.com';
  SendMessage(Wc, wm_Control, cm_Browse, Handle);
  Mp^.WebSite := 'www.google.com';
  SendMessage(Wc, wm_Control, cm_Browse, Handle);}
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Wc := 0;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  //Clean up Instance of WebCrawler if nesc.
  ShowWindow(Wc, sw_Show);
end;

Procedure TForm1.WndProc(var Message: TMessage);
begin
  Inherited WndProc(Message);
  If Message.Msg = wm_Control then
    Case Message.wParam of
      cm_FinishedURL:
        Memo1.Lines.Add(StrPas(URLText));
      cm_FinishedDL:
        Memo1.Lines.Add(MP^.FileName);
    end;
end;

end.
