unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DDirectDraw, ddraw, Menus;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Size1: TMenuItem;
    N1x1: TMenuItem;
    N2x1: TMenuItem;
    N3x1: TMenuItem;
    N1x2: TMenuItem;
    N2x2: TMenuItem;
    N3x2: TMenuItem;
    N1x3: TMenuItem;
    N2x3: TMenuItem;
    N3x3: TMenuItem;
    Rotation1: TMenuItem;
    Stop1: TMenuItem;
    Slow1: TMenuItem;
    Fast1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure N3x3Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure Slow1Click(Sender: TObject);
    procedure Fast1Click(Sender: TObject);
  private
    UpdateDelay: Longint;
    lastTickCount, currentFrame, thisTickCount: Integer;
    haveBackground: Boolean;

    DD: TDirectDraw;
    DDSPrimary, DDSOne: TDirectDrawSurface;
    DDClipper: TDirectDrawClipper;
    DDPal: TDirectDrawPalette;

    procedure RestoreAll;
    procedure UpdateFrame(Sender: TObject; var Done: Boolean);

  protected
    procedure WndProc(var Message: TMessage); override;
    procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;

  public
    { Public declarations }
  end;


const
  SIZEX = 64;
  SIZEY = 64;
  szBitmap = 'donut';

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  ddsd: TDDSURFACEDESC;
begin
  UpdateDelay := 13;
  lastTickCount := 0;
  currentFrame := 0;
  haveBackground := False;

  try
    {*
     * create the main DirectDraw object
     *}
    DD := TDirectDraw.Create( nil );
    DD.SetCooperativeLevel( Handle, DDSCL_NORMAL );

    // Create the primary surface
    ddsd.dwSize := sizeof( ddsd );
    ddsd.dwFlags := DDSD_CAPS;
    ddsd.ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE;

    DDSPrimary := TDirectDrawSurface.Create( DD, ddsd );

    // create a clipper for the primary surface
    DDClipper := TDirectDrawClipper.Create( DD, 0 );
    DDClipper.Window := Handle;

    DDSPrimary.Clipper := DDClipper;

    // load our palette
    DDPal := DD.LoadPalette( szBitmap );

    if (DDSPrimary.PixelFormat.dwFlags and DDPF_PALETTEINDEXED8) <> 0 then
      DDSPrimary.Palette := DDPal;

    // load our bitmap
    DDSOne := DD.LoadBitmap( szBitmap, 0, 0 );
  except
    on EDelphiDirectDrawError do
    begin
      ShowMessage('DirectDraw Init failed');
      raise;
    end;
  end;

  Application.OnIdle := UpdateFrame;
end;


{*
 * restoreAll
 *
 * restore all lost objects
 *}
procedure TMainForm.RestoreAll;
begin
  DDSPrimary.Restore;
  DDSOne.Restore;
  DDSOne.ReLoadBitmap( szBitmap );
end;


{*
 * updateFrame
 *
 * Decide what needs to be blitted next, wait for flip to complete,
 * then flip the buffers.
 *}
procedure TMainForm.UpdateFrame(Sender: TObject; var Done: Boolean);
var
  rcRect, destRect: TRect;
  pt: TPoint;
begin
  Done := False;

  // try to restore the surface
  if DDSPrimary.IsLost then
    try
      RestoreAll
    except
      on EDirectDrawError do exit;
    end;

  thisTickCount := GetTickCount;
  if((thisTickCount - lastTickCount) <= UpdateDelay) then
    exit;

  // Move to next frame;
  lastTickCount := thisTickCount;
  Inc( currentFrame );
  if (currentFrame > 59) then
    currentFrame := 0;

  // Blit the stuff for the next frame
  rcRect.left   := currentFrame mod 10 * 64;
  rcRect.top    := currentFrame div 10 * 64;
  rcRect.right  := currentFrame mod 10 * 64 + 64;
  rcRect.bottom := currentFrame div 10 * 64 + 64;

  destRect := GetClientRect;
  if (destRect.right  < 128) then destRect.right := 64;
  if (destRect.bottom < 64) then destRect.bottom := 64;

  pt := ClientToScreen( Point(0,0) );
  OffsetRect( destRect, pt.x, pt.y );

  try
    DDSPrimary.Blt( @destRect, DDSOne, @rcRect, DDBLT_WAIT, nil );
  except
    on M: EDirectDrawError do
      if M.ErrorCode <> DDERR_SURFACELOST then raise;
  end;
end;


procedure TMainForm.WndProc(var Message: TMessage);
begin
  if (Message.Msg = WM_QUERYNEWPALETTE)
    or ((Message.Msg = WM_PALETTECHANGED) and (Message.wParam <> Handle)) then
  try
    // install our palette here
    if Assigned(DDPal) and
    ((DDSPrimary.PixelFormat.dwFlags and DDPF_PALETTEINDEXED8) <> 0) then
      DDSPrimary.Palette := DDPal;

    // reload the bitmap into the surface because the palette
    // has changed..
    DDSOne.ReLoadBitmap( szBitmap );
  except
    on M: EDirectDrawError do
      if M.ErrorCode <> DDERR_SURFACELOST then raise;
  end;

  inherited WndProc( Message );
end;


procedure TMainForm.WMGetMinMaxInfo( var Message :TWMGetMinMaxInfo );
begin
  with Message.MinMaxInfo^ do
  begin
    ptMinTrackSize.X := SIZEX;
    ptMinTrackSize.Y := SIZEY;
  end;
  Message.Result := 0;
  inherited;
end;


procedure TMainForm.FormDestroy(Sender: TObject);
begin
  DD.Free;
end;

procedure TMainForm.N3x3Click(Sender: TObject);
begin
  ClientWidth := SIZEX;
  ClientHeight := SIZEX;
  ClientWidth := SIZEX * (((TMenuItem(Sender).Tag-1) mod 3) + 1);
  ClientHeight := SIZEY * ((TMenuItem(Sender).Tag+2) div 3);
end;

procedure TMainForm.Stop1Click(Sender: TObject);
begin
  UpdateDelay := $7fffffff;
end;

procedure TMainForm.Slow1Click(Sender: TObject);
begin
  UpdateDelay := 200;
end;

procedure TMainForm.Fast1Click(Sender: TObject);
begin
  UpdateDelay := 13;
end;



end.
