unit LightMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Menus, CgWindow, CgTypes, CgLight, GL, GLu;

type
  TLForm = class(TCGForm)
    Timer: TTimer;
    Popup: TPopupMenu;
    ColorDlg: TColorDialog;
    pLightOn: TMenuItem;
    pLightOff: TMenuItem;
    N1: TMenuItem;
    pAmbient: TMenuItem;
    pDiffuse: TMenuItem;
    pSpecular: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);
    procedure pAmbientClick(Sender: TObject);
    procedure pDiffuseClick(Sender: TObject);
    procedure pSpecularClick(Sender: TObject);
    procedure pLightOnClick(Sender: TObject);
    procedure pLightOffClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  LForm: TLForm;
  l: TCGLight;
  a: Integer = 0;

implementation

{$R *.DFM}

procedure TLForm.FormCreate(Sender: TObject);
const
  spec: array [0..3] of Single = (1, 1, 1, 1);
begin

  InitGL;

  glClearColor(0, 0, 0, 0);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);

  glMaterialfv(GL_FRONT, GL_SPECULAR, @spec);
  glMaterialf(GL_FRONT, GL_SHININESS, 20);

  l := TCGLight.Create(GL_LIGHT0);
  l.Position := cgVector(1, 1, 3);
  l.Enable;

end;

procedure TLForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  l.Free;

end;

procedure TLForm.TimerTimer(Sender: TObject);
begin

  a := (a + 1) mod 360;
  Paint;

end;

procedure TLForm.pAmbientClick(Sender: TObject);
begin

  Timer.Enabled := FALSE;
  if ColorDlg.Execute then l.Ambient := cgTColorToCGColorF(ColorDlg.Color, 1);
  Timer.Enabled := TRUE;

end;

procedure TLForm.pDiffuseClick(Sender: TObject);
begin

  Timer.Enabled := FALSE;
  if ColorDlg.Execute then l.Diffuse := cgTColorToCGColorF(ColorDlg.Color, 1);
  Timer.Enabled := TRUE;

end;

procedure TLForm.pSpecularClick(Sender: TObject);
begin

  Timer.Enabled := FALSE;
  if ColorDlg.Execute then l.Specular := cgTColorToCGColorF(ColorDlg.Color, 1);
  Timer.Enabled := TRUE;

end;

procedure TLForm.pLightOnClick(Sender: TObject);
begin

  l.Enable;

end;

procedure TLForm.pLightOffClick(Sender: TObject);
begin

  l.Disable;

end;

procedure TLForm.FormPaint(Sender: TObject);
var
  q: PGLuQuadricObj;
begin

  glClear(GL_COLOR_BUFFER_BIT OR GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;
  glRotatef(a, 1, 2, 3);

  q := gluNewQuadric;
  gluSphere(q, 0.6, 32, 16);
  gluDeleteQuadric(q);

  PageFlip;

end;

end.
