unit FlareMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CgWindow, CgTypes, LensFlare, GL;

type
  TFForm = class(TCGForm)
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormPaint(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FForm: TFForm;
  Flare: TLFLensFlare;

implementation

{$R *.DFM}

procedure TFForm.FormCreate(Sender: TObject);
begin

  ClientWidth := 640;
  ClientHeight := 480;  // I hate big forms in the design view, so resize at runtime.
  InitGL;
  glEnable(GL_BLEND);   // Very important.
  // Setup a 4 by 3 viewport.
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  glOrtho(-2, 2, -1.5, 1.5, -2, 2);
  glMatrixMode(GL_MODELVIEW);

  // Setup a nice flare.
  Flare := TLFLensFlare.Create;
  Flare.Size := 0.5;
  Flare.Position := cgVector(-0.5, 0.5, 0);
  Randomize;
  Flare.Seed := 13603;
  Caption := Format('Lens flare (seed %d)', [Flare.Seed]);

end;

procedure TFForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  Flare.Free;

end;

procedure TFForm.FormPaint(Sender: TObject);
begin

  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;
  Flare.Render;  // Just render.
  glFinish;
  PageFlip;

end;

procedure TFForm.FormKeyPress(Sender: TObject; var Key: Char);
begin

  // Press SPACE to reseed the flare.
  if Key = ' ' then
  begin
    Flare.Seed := Random(32768);
    Caption := Format('Lens flare (seed %d)', [Flare.Seed]);
  end
  // Press G to toggle glow.
  else if Key in ['g', 'G'] then
    if feGlow in Flare.Elements then Flare.Elements := Flare.Elements - [feGlow]
    else Flare.Elements := Flare.Elements + [feGlow]
  // Press I to toggle ring.
  else if Key in ['i', 'I'] then
    if feRing in Flare.Elements then Flare.Elements := Flare.Elements - [feRing]
    else Flare.Elements := Flare.Elements + [feRing]
  // Press S to toggle streaks.
  else if Key in ['s', 'S'] then
    if feStreaks in Flare.Elements then Flare.Elements := Flare.Elements - [feStreaks]
    else Flare.Elements := Flare.Elements + [feStreaks]
  // Press R to toggle rays.
  else if Key in ['r', 'R'] then
    if feRays in Flare.Elements then Flare.Elements := Flare.Elements - [feRays]
    else Flare.Elements := Flare.Elements + [feRays]
  // Press N to toggle secondaries.
  else if Key in ['n', 'N'] then
    if feSecondaries in Flare.Elements then Flare.Elements := Flare.Elements - [feSecondaries]
    else Flare.Elements := Flare.Elements + [feSecondaries];

  Paint;

end;

procedure TFForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  fx, fy: Single;
begin

  // Put the flare where the cursor is.
  fx := (X - (ClientWidth / 2)) / (ClientWidth / 4);
  fy := (Y - (ClientHeight / 2)) / (ClientHeight / 3);
  Flare.Position.x := fx;
  Flare.Position.y := -fy;
  Paint;

end;

end.
