{*********************************************************************}
{*                       FIGHTER                                     *}
{* Modify view point - keys:                                         *}
{* Up, Down, Left, Right, Insert, Delete, Home, End, PgUp, PgDown    *}
{*********************************************************************}
{* Translation to Delphi : Krasnov Mike      softgl@chat.ru          *}
{*********************************************************************}

// (c) Juan Gril's                         http://www.uic.edu/~jayvee/

unit frmMain;
interface

uses
  Windows, Messages, Classes, Graphics, Forms, ExtCtrls, Controls,
  CgWindow, CgTypes, CgGeometry, CgLight, CgTexture, GL, GLu;

type
  TfrmGL = class(TCGForm)
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    angle, angy, acc, posh : GLFloat;
    Perspective : GLFloat;
    VERTEX_fighter : Array[0..1991] of GLFloat;
    L : TCGLight;

    procedure Camera;
    procedure Initialize_fighter;
  protected
    procedure WMPaint(var Msg: TWMPaint); message WM_PAINT;
  end;

const
  FIGHTERLIST = 1;

var
  frmGL: TfrmGL;

implementation

{$R *.DFM}

procedure glInterleavedArrays(format: GLenum; stride: GLsizei; const pointer); stdcall; external OpenGL32;
procedure glDrawElements(mode: GLenum; count: GLsizei; atype: GLenum; const indices); stdcall; external OpenGL32;
const
 GL_N3F_V3F = $2A25;

{$I InitFighter}

procedure TfrmGL.Initialize_fighter;
var
  f : File of GLFloat;
  i : Integer;
begin
  AssignFile (f, 'fighter.gl');
  Reset (f);
  For i := 0 to 1991 do
   Read (f, VERTEX_fighter [i]);
  CloseFile (f);

  glInterleavedArrays(GL_N3F_V3F, 0, VERTEX_fighter);
  glNewList(FIGHTERLIST, GL_COMPILE);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[0]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[4]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[8]);
    glDrawElements(GL_TRIANGLES, 996, GL_UNSIGNED_INT, INDEX_fighter[0]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[12]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[16]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[20]);
    glDrawElements(GL_TRIANGLES, 276, GL_UNSIGNED_INT, INDEX_fighter[996]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[24]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[28]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[32]);
    glDrawElements(GL_TRIANGLES, 228, GL_UNSIGNED_INT, INDEX_fighter[1272]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[36]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[40]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[44]);
    glDrawElements(GL_TRIANGLES, 192, GL_UNSIGNED_INT, INDEX_fighter[1500]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[48]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[52]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[56]);
    glDrawElements(GL_TRIANGLES, 24, GL_UNSIGNED_INT, INDEX_fighter[1692]);
    glMaterialfv(GL_FRONT, GL_AMBIENT, @MATERIAL_fighter[60]);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, @MATERIAL_fighter[64]);
    glMaterialfv(GL_FRONT, GL_SPECULAR, @MATERIAL_fighter[68]);
    glDrawElements(GL_TRIANGLES, 18, GL_UNSIGNED_INT, INDEX_fighter[1716]);
  glEndList;
end;

procedure TfrmGL.Camera;
begin
 glMatrixMode(GL_PROJECTION);
 glLoadIdentity;
 gluPerspective(Perspective, 1.0, 0.1, 200);
 glMatrixMode(GL_MODELVIEW);
 glLoadIdentity;
 gluLookAt(0.0, 30.0, 10.0, 0, 0, -5.0+acc, 0, 1, 0);
end;

procedure TfrmGL.WMPaint(var Msg: TWMPaint);
var
 ps : TPaintStruct;
begin
 BeginPaint(Handle, ps);

 glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
 Camera;
 glPushMatrix;
 glTranslatef (posh, 0.0, 0.0);
 glRotatef (angle, 0.0, 0.0, 1.0);
 glRotatef (angy - 90.0, 1.0, 0.0, 0.0);
 glCallList (FIGHTERLIST);
 glPopMatrix;

 PageFlip;
 EndPaint(Handle, ps);
end;

procedure TfrmGL.FormCreate(Sender: TObject);
begin
 InitGL;

 angle := 0;
 angy := 0.0;
 acc := 0;
 posh := 0;
 Perspective := 40.0;

 L := TCGLight.Create(GL_LIGHT0);
 L.Enable;

 glEnable(GL_DEPTH_TEST);

 Initialize_fighter;
end;

procedure TfrmGL.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Case Key of
    VK_ESCAPE : begin
                Close;
                Exit;
                end;
    VK_LEFT :   begin
	        angle := angle + 3;
	        If angle >= 360 then angle := 0;
	        end;
    VK_RIGHT:   begin
	        angle := angle - 3;
	        If angle <= -360 then angle := 0;
                end;
    VK_UP :     begin
	        acc := acc + 0.3;
	        If acc > 10 then acc := 10;
                end;
    VK_DOWN :   begin
	        acc := acc-0.3;
	        If acc < 0 then acc := 0;
                end;
    VK_HOME :   posh := posh - 0.3;
    VK_END :    posh := posh + 0.3;
    VK_INSERT : Perspective := Perspective - 0.5;
    VK_DELETE : Perspective := Perspective + 0.5;
    // PgUp
    33 :        begin
                angy := angy - 3;
                If angy < -360 then angy := 0;
                end;
    // PgDown
    34 :        begin
                angy := angy + 3;
                If angy > 360 then angy := 0;
                end;
   end; {case}
   InvalidateRect(Handle, nil, False);
end;

procedure TfrmGL.FormResize(Sender: TObject);
begin
 InvalidateRect(Handle, nil, False);
end;

procedure TfrmGL.FormDestroy(Sender: TObject);
begin
 glDeleteLists (FIGHTERLIST, 1);
 L.Free;
end;


end.

