unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DDirectDraw, DDraw, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    DD: TDirectDraw;
    DDSPrimary, DDSBack, DDSOne, DDSTwo: TDirectDrawSurface;
    DDPal: TDirectDrawPalette;
    Phase: Byte;

    procedure finiObjects;
    procedure doInit;
    procedure InitSurfaces;
    function RestoreAll: Boolean;
  public
  end;

const
  szBitmap = 'DDEX3';
  TIMER_RATE = 500;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(*
 * finiObjects
 *
 * finished with all objects we use; release them
 *)
procedure TForm1.finiObjects;
begin
  Timer1.Enabled := False;

  DD.RestoreDisplayMode;
  DD.Free;
end;


(*
 * restoreAll
 *
 * restore all lost objects
 *)
function TForm1.restoreAll: Boolean;
begin
  Result := False;
  if not DDSPrimary.Restore or not DDSOne.Restore or not DDSTwo.Restore then
    exit;

  InitSurfaces;
  Result := True;
end;


(*
 * doInit - do work required for every instance of the application:
 *                create the window, initialize data
 *)
procedure TForm1.doInit;
var
  ddscaps: TDDSCaps;
  ddsd: TDDSurfaceDesc;
begin
  try
    (*
     * create the main DirectDraw object
     *)
    DD := TDirectDraw.Create( nil );

    // Get exclusive mode
    DD.SetCooperativeLevel( Handle, DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN );

    DD.SetDisplayMode( 640, 480, 8 );

    // Create the primary surface with 1 back buffer
    ddsd.dwSize := sizeof( ddsd );
    ddsd.dwFlags := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE or
              DDSCAPS_FLIP or
              DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount := 1;
    DDSPrimary := TDirectDrawSurface.Create( DD, ddsd );

    // Create a offscreen bitmap.
    ddsd.dwFlags := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps := DDSCAPS_OFFSCREENPLAIN;
    ddsd.dwHeight := 480;
    ddsd.dwWidth := 640;
    DDSOne := TDirectDrawSurface.Create( DD, ddsd );

    // Create another offscreen bitmap.
    DDSTwo := TDirectDrawSurface.Create( DD, ddsd );

    // Get a pointer to the back buffer
    ddscaps.dwCaps := DDSCAPS_BACKBUFFER;
    DDSBack := DDSPrimary.GetAttachedSurface( ddscaps );

    // Create a Direct Draw Palette and associate it with the front buffer
    DDPal := DD.LoadPalette( szBitmap );

    if (DDSPrimary.PixelFormat.dwFlags and DDPF_PALETTEINDEXED8) <> 0 then
      DDSPrimary.Palette := DDPal;

    InitSurfaces;

    Timer1.Interval := TIMER_RATE;

    Timer1.Enabled := True;
  except
    on Exception do
    begin
      ShowMessage( 'Direct Draw Init Failed' );
      finiObjects;
      raise;
    end;
  end;
end;


(*
 * InitSurfaces - This function reads the bitmap file FRNTBACK.BMP
 * and stores half of it in offscreen surface 1 and the other half in
 * offscreen surface 2.
 *)
procedure TForm1.InitSurfaces;
var
  hbm: HBitmap;
begin
  // Load our bitmap resource.
  hbm := HBITMAP(LoadImage(HInstance, szBitmap, IMAGE_BITMAP, 0, 0,
    LR_CREATEDIBSECTION));

  if (hbm = 0) then
    Exception.Create('Couldn''t load image');

  try
    DDSOne.CopyBitmap( hbm, 0, 0, 640, 480);
    DDSTwo.CopyBitmap( hbm, 0, 480, 640, 480);
  finally
    DeleteObject(hbm);
  end;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
var
  rcRect: TRect;
  pdds: TDirectDrawSurface;
begin
  rcRect := Rect( 0, 0, 640, 480 );

  if ( phase <> 0 ) then
  begin
    pdds := DDSTwo;
    phase := 0;
  end
  else
  begin
    pdds := DDSOne;
    phase := 1;
  end;

  try
    if DDSPrimary.IsLost then
      if not RestoreAll then exit;

    DDSBack.BltFast( 0, 0, pdds, @rcRect, DDBLTFAST_WAIT );

    // Flip surfaces
    DDSPrimary.Flip( nil, DDFLIP_WAIT  );
  except
    on E: EDirectDrawError do
      if E.ErrorCode <> DDERR_SURFACELOST then raise;
  end;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  Phase := 0;

  Screen.Cursor := crNone;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_F10 then
    Close;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  finiObjects;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  if (DD = nil) then
    DoInit;
end;

end.
