program lesson26a;

{   kd pro Delphi 7}

uses
  Windows,
  Messages,
  OpenGL,sysutils, DXFProcs;

procedure glGenTextures(n: GLsizei; var textures: GLuint); stdcall; external opengl32;
procedure glBindTexture(target: GLenum; texture: GLuint); stdcall; external opengl32;

const // Parametry svtla
  LightAmb: array [0..3] of GLFloat = (0.7,0.7,0.7,1.0);    // Okoln
  LightDif: array [0..3] of GLFloat = (1.0,1.0,1.0,1.0);    // Rozptlen
  LightPos: array [0..3] of GLFloat = (4.0,4.0,6.0,1.0);    // Pozice

var
  h_Rc: HGLRC;		                  // Trval Rendering Context
  h_Dc: HDC;                        // Privtn GDI Device Context
  h_Wnd: HWND;                      // Obsahuje Handle naeho okna
  keys: array [0..255] of BOOL;	    // Pole pro ukldn vstupu z klvesnice
  Active: bool = true;              // Ponese informaci o tom, zda je okno aktivn
  FullScreen:bool = true;           // Ponese informaci o tom, zda je program ve fullscreenu
  q: GLUquadricObj;                 // Quadratic pro kreslen koule (me)
  xrot: GLFloat = 0;                // Rotace v ose x
  yrot: GLFloat = 0;                // Rotace v ose y
  xrotspeed: GLfloat = 0;           // Rychlost x rotace
  yrotspeed: GLfloat = 0;           // Rychlost y rotace
  zoom: GLfloat = -7.0;             // Hloubka v obrazovce
  height: GLfloat = 2.0;            // Vka me nad scnou
  texture: array [0..2] of GLuint;  // 3 textury

{function LoadBMP(FileName: pchar):PTAUX_RGBImageRec;        // Nahraje bitmapu
begin
  if Filename = '' then                                     // Byla pedna cesta k souboru?
    begin
    Result := nil;                                          // Pokud ne, konec
    exit;
    end;
  if not FileExists(Filename) then                          // Existuje soubor?
    begin
    Result := nil;                                          // Pokud ne, konec
    exit;
    end;
  Result := auxDIBImageLoadA(FileName);                     // Nate bitmapu a vrt na ni ukazatel
end;}

function LoadGLTextures: Bool;                              // Loading bitmapy a konverze na texturu
var TextureImage: array [0..2] of TBMPBits;
    Status: Bool;                                           // Indikuje chyby
    i: integer;                                             // Cyklus
begin
  //Status := false;
  ZeroMemory(@TextureImage,sizeof(TextureImage));           // Vynuluje pam
  TextureImage[0] := LoadBits('EnvWall.bmp', nil);           // Nahraje bitmapu
  TextureImage[1] := LoadBits('Ball.bmp', nil);              // Nahraje bitmapu
  TextureImage[2] := LoadBits('EnvRoll.bmp', nil);           // Nahraje bitmapu
  //if Assigned(TextureImage[0]) and Assigned(TextureImage[1])
  //  and Assigned(TextureImage[2]) then                      // Ve je bez problm?
  //  begin
    Status := true;                                         // Ve je bez problm
    glGenTextures(3,Texture[0]);                            // Generuje textury
    for i := 0 to 2 do
      begin
      glBindTexture(GL_TEXTURE_2D,texture[i]);                // Typick vytven textury z bitmapy
      glTexImage2D(GL_TEXTURE_2D,0,4,TextureImage[i].Width,TextureImage[i].Height,0,GL_RGBA,GL_UNSIGNED_BYTE,TextureImage[i].Bits);    // Vlastn vytven textury
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);   // Filtrovn pi zvten
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);   // Filtrovn pi zmenen
      end;
  //  end;
  Result := Status;                                         // Oznm ppadn chyby
  For I := 0 to 2 do
    FreeMem(TextureImage[I].Bits, TextureImage[I].Alloc);
end;

procedure ReSizeGLScene(Width: GLsizei; Height: GLsizei); // Zmna velikosti a inicializace OpenGL okna
begin
  if (Height=0) then		                                  // Zabezpeen proti dlen nulou
     Height:=1;                                           // Nastav vku na jedna
  glViewport(0, 0, Width, Height);                        // Resetuje aktuln nastaven
  glMatrixMode(GL_PROJECTION);                            // Zvol projekn matici
  glLoadIdentity();                                       // Reset matice
  gluPerspective(45.0,Width/Height,0.1,100.0);            // Vpoet perspektivy
  glMatrixMode(GL_MODELVIEW);                             // Zvol matici Modelview
  glLoadIdentity;                                         // Reset matice
end;


function InitGL:bool;	                              // Vechno nastaven OpenGL
begin
  if not LoadGLTextures then                        // Nahraje texturu
    begin
    Result := false;
    exit;
    end;
  glShadeModel(GL_SMOOTH);			                    // Povol jemn stnovn
  glClearColor(0.2, 0.5, 1.0, 1.0);	  	            // Svtle modr pozad
  glClearDepth(1.0);				                        // Nastaven hloubkovho bufferu
  glClearStencil(0);                                // Nastaven mazn stencil bufferu
  glEnable(GL_DEPTH_TEST);			                    // Povol hloubkov testovn
  glDepthFunc(GL_LEQUAL);				                    // Typ hloubkovho testovn
  glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST); // Nejlep perspektivn korekce
  glEnable(GL_TEXTURE_2D);                          // Zapne mapovn textur
  glLightfv(GL_LIGHT0,GL_AMBIENT,@LightAmb);        // Okoln
  glLightfv(GL_LIGHT0,GL_DIFFUSE,@LightDif);        // Rozptylov
  glLightfv(GL_LIGHT0,GL_POSITION,@LightPos);       // Pozice
  glEnable(GL_LIGHT0);                              // Povol svtlo 0
  glEnable(GL_LIGHTING);                            // Povol svtla
  q := gluNewQuadric;                               // Nov quadratic
  gluQuadricNormals(q,GL_SMOOTH);                   // Normly pro svtlo
  gluQuadricTexture(q,  TRUE);                     // Texturov koordinty
  glTexGeni(GL_S,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);// Automatick mapovn textur
  glTexGeni(GL_T,GL_TEXTURE_GEN_MODE,GL_SPHERE_MAP);// Automatick mapovn textur
  Result:=true;                                     // Inicializace probhla v podku
end;

procedure DrawObject;                               // Vykresl plov m
begin
  glColor3f(1.0,1.0,1.0);                           // Bl barva
  glBindTexture(GL_TEXTURE_2D,texture[1]);          // Zvol texturu me
  gluSphere(q,0.35,32,16);                          // Nakresl kouli
  glBindTexture(GL_TEXTURE_2D,texture[2]);          // Zvol texturu svtla
  glColor4f(1.0,1.0,1.0,0.4);                       // Bl barva s 40% alfou
  glEnable(GL_BLEND);                               // Zapne blending
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);                 // Md blendingu
  glEnable(GL_TEXTURE_GEN_S);                       // Zapne kulov mapovn
  glEnable(GL_TEXTURE_GEN_T);                       // Zapne kulov mapovn
  gluSphere(q,0.35,32,16);                          // Stejn koule jako ped chvl
  glDisable(GL_TEXTURE_GEN_S);                      // Vypne kulov mapovn
  glDisable(GL_TEXTURE_GEN_T);                      // Vypne kulov mapovn
  glDisable(GL_BLEND);                              // Vepne blending
end;

procedure DrawFloor;                                // Vykresl podlahu
begin
  glBindTexture(GL_TEXTURE_2D,texture[0]);          // Zvol texturu podlahy
  glBegin(GL_QUADS);                                // Kreslen obdlnk
    glNormal3f(0.0, 1.0, 0.0);                      // Normlov vektor m vzhru
    glTexCoord2f(0.0, 1.0);                         // Lev doln bod textury
    glVertex3f(-2.0, 0.0, 2.0);                     // Lev doln bod podlahy
    glTexCoord2f(0.0, 0.0);                         // Lev horn bod textury
    glVertex3f(-2.0, 0.0,-2.0);                     // Lev horn bod podlahy
    glTexCoord2f(1.0, 0.0);                         // Prav horn bod textury
    glVertex3f( 2.0, 0.0,-2.0);                     // Prav horn bod podlahy
    glTexCoord2f(1.0, 1.0);                         // Prav doln bod textury
    glVertex3f( 2.0, 0.0, 2.0);                     // Prav doln bod podlahy
  glEnd();                                          // Konec kreslen
end;

function DrawGLScene:bool;                            // Vykreslovn
var
  eqr: array [0..3] of Double;                          // Pouito pro odraen objekt
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT
          or GL_STENCIL_BUFFER_BIT);                    // Smae obrazovku, hloubkov buffer a stencil buffer
  eqr[0] := 0.0;                                        // Rovnice oezvac plochy
  eqr[1] := -1.0;
  eqr[2] := 0.0;
  eqr[3] := 0.0;
  glLoadIdentity();	                                    // Reset matice
  glTranslatef(0.0,-0.6,zoom);                          // Zoom a vyven kamery nad podlahu
  glColorMask(FALSE,FALSE,FALSE,FALSE);     // Nastav masku barev, aby se nic nezobrazilo
  glEnable(GL_STENCIL_TEST);                            // Zapne stencil buffer pro pamov obraz podlahy
  glStencilFunc(GL_ALWAYS,1,1);                         // Pokad probhne, reference, maska
  glStencilOp(GL_KEEP,GL_KEEP,GL_REPLACE);              // Vykreslenm nastavme konkrtn bit ve stencil bufferu na 1
  glDisable(GL_DEPTH_TEST);                             // Vypne testovn hloubky
  DrawFloor;                                            // Vykresl podlahu (do stencil bufferu ne na scnu)
  glEnable(GL_DEPTH_TEST);                              // Zapne testovn hloubky
  glColorMask(TRUE,TRUE,TRUE,TRUE);         // Povol zobrazovn barev
  glStencilFunc(GL_EQUAL,1,1);                          // Zobraz se pouze pixely na jednikch ve stencil bufferu (podlaha)
  glStencilOp(GL_KEEP,GL_KEEP,GL_KEEP);                 // Nemnit obsah stencil bufferu
  glEnable(GL_CLIP_PLANE0);                             // Zapne oezvac testy pro odraz
  glClipPlane(GL_CLIP_PLANE0,@eqr);                      // Rovnice oezvac roviny
  glPushMatrix;                                         // Zloha matice
    glScalef(1.0,-1.0,1.0);                             // Zrcadlen smru osy y
    glLightfv(GL_LIGHT0,GL_POSITION,@LightPos);         // Umstn svtla
    glTranslatef(0.0,height,0.0);                       // Umstn me
    glRotatef(xrot,1.0,0.0,0.0);                        // Rotace na ose x
    glRotatef(yrot,0.0,1.0,0.0);                        // Rotace na ose y
    DrawObject;                                         // Vykresl m (odraz)
  glPopMatrix;                                          // Obnov matici
  glDisable(GL_CLIP_PLANE0);                            // Vypne oezvac rovinu
  glDisable(GL_STENCIL_TEST);                           // U nebudeme potebovat stencil testy
  glLightfv(GL_LIGHT0,GL_POSITION,@LightPos);           // Umstn svtla
  glEnable(GL_BLEND);                                   // Zapne blending, jinak by se odraz me nezobrazil
  glDisable(GL_LIGHTING);                               // Kvli blendingu vypneme svtla
  glColor4f(1.0,1.0,1.0,0.8);                           // Bl barva s 80% prhlednost
  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);     // Funkce na bzi alfy zdroje a jedna mnus alfy cle
  DrawFloor;                                            // Vykresl podlahu
  glEnable(GL_LIGHTING);                                // Zapne svtla
  glDisable(GL_BLEND);                                  // Vypne blending
  glTranslatef(0.0,height,0.0);                         // Umstn me
  glRotatef(xrot,1.0,0.0,0.0);                          // Rotace na ose x
  glRotatef(yrot,0.0,1.0,0.0);                          // Rotace na ose y
  DrawObject;                                           // Vykresl m
  xrot := xrot + xrotspeed;                             // Zvt natoen
  yrot := yrot + yrotspeed;                             // Zvt natoen
  glFlush;                                              // Vyprzdn pipeline
  Result := true;                                       // Vykreslen probhlo v podku
end;


function WndProc(hWnd: HWND;                            // Handle okna
                 message: UINT;                         // Zprva pro okno
                 wParam: WPARAM;                        // Doplkov informace
                 lParam: LPARAM):                       // Doplkov informace
                                  LRESULT; stdcall;
begin
  if message=WM_SYSCOMMAND then                         // Systmov pkaz
    begin
      case wParam of                                    // Typ systmovho pkazu
        SC_SCREENSAVE,SC_MONITORPOWER:                  // Pokus o zapnut etie obrazovky, Pokus o pechod do spornho reimu?
          begin
            result:=0;                                  // Zabrn obojmu
            exit;
          end;
      end;
    end;
  case message of                                       // Vtven podle pchoz zprvy
    WM_ACTIVATE:                                        // Zmna aktivity okna
      begin
        if (Hiword(wParam)=0) then                      // Zkontroluje zda nen minimalizovan
          active:=true                                  // Program je aktivn
        else
          active:=false;                                // Program nen aktivn
        Result:=0;                                      // Nvrat do hlavnho cyklu programu
      end;
    WM_CLOSE:                                           // Povel k ukonen programu
      Begin
        PostQuitMessage(0);                             // Pole zprvu o ukonen
        result:=0                                       // Nvrat do hlavnho cyklu programu
      end;
    WM_KEYDOWN:                                         // Stisk klvesy
      begin
        keys[wParam] := TRUE;                           // Oznm to programu
        result:=0;                                      // Nvrat do hlavnho cyklu programu
      end;
    WM_KEYUP:                                           // Uvolnn klvesy
      begin
    	keys[wParam] := FALSE;                            // Oznm to programu
        result:=0;                                      // Nvrat do hlavnho cyklu programu
      end;
    WM_SIZe:                                            // Zmna velikosti okna
      begin
    	ReSizeGLScene(LOWORD(lParam),HIWORD(lParam));     // LoWord=ka, HiWord=Vka
        result:=0;                                      // Nvrat do hlavnho cyklu programu
      end
    else
      // Pedn ostatnch zprv systmu
      begin
      	Result := DefWindowProc(hWnd, message, wParam, lParam);
      end;
    end;
end;


procedure KillGLWindow;                                 // Zavrn okna
var
  devmode: Tdevmode;
begin
  if FullScreen then                                    // Jsme ve fullscreenu?
    begin
      ChangeDisplaySettings(devmode,0);           // Pepnut do systmu
      showcursor(true);                                 // Zobraz kurzor myi
    end;
  if h_rc<> 0 then                                      // Mme rendering kontext?
    begin
      if (not wglMakeCurrent(h_Dc,0)) then              // Jsme schopni oddlit kontexty?
        MessageBox(0,'Release of DC and RC failed.',' Shutdown Error',MB_OK or MB_ICONERROR);
      if (not wglDeleteContext(h_Rc)) then              // Jsme schopni smazat RC?
        begin
          MessageBox(0,'Release of Rendering Context failed.',' Shutdown Error',MB_OK or MB_ICONERROR);
          h_Rc:=0;                                      // Nastav hRC na 0
        end;
    end;
  if (h_Dc=1) and (releaseDC(h_Wnd,h_Dc)<>0) then       // Jsme schopni uvolnit DC
    begin
      MessageBox(0,'Release of Device Context failed.',' Shutdown Error',MB_OK or MB_ICONERROR);
      h_Dc:=0;                                          // Nastav hDC na 0
    end;
  if (h_Wnd<>0) and (not destroywindow(h_Wnd))then      // Jsme schopni odstranit okno?
    begin
      MessageBox(0,'Could not release hWnd.',' Shutdown Error',MB_OK or MB_ICONERROR);
      h_Wnd:=0;                                         // Nastav hWnd na 0
    end;
  if (not UnregisterClass('OpenGL',hInstance)) then     // Jsme schopni odregistrovat tdu okna?
    begin
      MessageBox(0,'Could Not Unregister Class.','SHUTDOWN ERROR',MB_OK or MB_ICONINFORMATION);
    end;
end;


function CreateGlWindow(title:Pchar; width,height,bits:integer;FullScreenflag:bool):boolean stdcall;
var
  Pixelformat: GLuint;            // Ukld formt pixel
  wc:TWndclass;                   // Struktura Windows Class
  dwExStyle:dword;                // Rozen styl okna
  dwStyle:dword;                  // Styl okna
  pfd: Tpixelformatdescriptor;     // Nastaven formtu pixel
  dmScreenSettings: TDevmode;      // Md zazen
  h_Instance:hinst;               // Instance okna
  WindowRect: TRect;              // Obdlnk okna
begin
  WindowRect.Left := 0;                               // Nastav lev okraj na nulu
  WindowRect.Top := 0;                                // Nastav horn okraj na nulu
  WindowRect.Right := width;                          // Nastav prav okraj na zadanou hodnotu
  WindowRect.Bottom := height;                        // Nastav spodn okraj na zadanou hodnotu
  h_instance:=GetModuleHandle(nil);                   // Zsk instanci okna
  FullScreen:=FullScreenflag;                         // Nastav promnnou fullscreen na sprvnou hodnotu
  with wc do
    begin
      style:=CS_HREDRAW or CS_VREDRAW or CS_OWNDC;    // Pekreslen pi zmn velikosti a vlastn DC
      lpfnWndProc:=@WndProc;                          // Definuje proceduru okna
      cbClsExtra:=0;                                  // dn extra data
      cbWndExtra:=0;                                  // dn extra data
      hInstance:=h_Instance;                          // Instance
      hIcon:=LoadIcon(0,IDI_WINLOGO);                 // Standardn ikona
      hCursor:=LoadCursor(0,IDC_ARROW);               // Standardn kurzor myi
      hbrBackground:=0;                               // Pozad nen nutn
      lpszMenuName:=nil;                              // Nechceme menu
      lpszClassName:='OpenGl';                        // Jmno tdy okna
    end;
  if  RegisterClass(wc)=0 then                        // Registruje tdu okna
    begin
      MessageBox(0,'Failed To Register The Window Class.','Error',MB_OK or MB_ICONERROR);
      Result:=false;                                  // Pi chyb vrt false
      exit;
    end;
  if FullScreen then                                  // Budeme ve fullscreenu?
    begin
      ZeroMemory( @dmScreenSettings, sizeof(dmScreenSettings) );  // Vynulovn pamti
      with dmScreensettings do
        begin
          dmSize := sizeof(dmScreenSettings);         // Velikost struktury Devmode
          dmPelsWidth  := width;	                    // ka okna
	        dmPelsHeight := height;                     // Vka okna
          dmBitsPerPel := bits;                       // Barevn hloubka
          dmFields     := DM_BITSPERPEL or DM_PELSWIDTH or DM_PELSHEIGHT;
        end;
      // Pokus se pout prv definovan nastaven
      if (ChangeDisplaySettings(dmScreenSettings, CDS_FULLSCREEN))<>DISP_CHANGE_SUCCESSFUL THEN
        Begin
          // Nejde-li fullscreen, me uivatel spustit program v okn nebo ho opustit
          if MessageBox(0,'This FullScreen Mode Is Not Supported. Use Windowed Mode Instead?'
                                             ,'NeHe GL',MB_YESNO or MB_ICONEXCLAMATION)= IDYES then
                FullScreen:=false                     // Bh v okn
          else
            begin
              // Zobraz uivateli zprvu, e program bude ukonen
              MessageBox(0,'Program Will Now Close.','Error',MB_OK or MB_ICONERROR);
              Result:=false;                          // Vrt FALSE
              exit;
            end;
          end;
    end;
  if FullScreen then                                  // Jsme stle ve fullscreenu?
    begin
      dwExStyle:=WS_EX_APPWINDOW;                     // Rozen styl okna
      dwStyle:=WS_POPUP or WS_CLIPSIBLINGS or WS_CLIPCHILDREN; // Styl okna
      Showcursor(false);                              // Skryje kurzor
    end
  else
    begin
      dwExStyle:=WS_EX_APPWINDOW or WS_EX_WINDOWEDGE;   // Rozen styl okna
      dwStyle:=WS_OVERLAPPEDWINDOW or WS_CLIPSIBLINGS or WS_CLIPCHILDREN; // Styl okna
    end;
  AdjustWindowRectEx(WindowRect,dwStyle,false,dwExStyle); // Pizpsoben velikosti okna
  // Vytvoen okna
  H_wnd:=CreateWindowEx(dwExStyle,                    // Rozen styl
                               'OpenGl',              // Jmno tdy
                               Title,                 // Titulek
                               dwStyle,               // Definovan styl
                               0,0,                   // Pozice
                               WindowRect.Right-WindowRect.Left,  // Vpoet ky
                               WindowRect.Bottom-WindowRect.Top,  // Vpoet vky
                               0,                     // dn rodiovsk okno
                               0,                     // Bez menu
                               hinstance,             // Instance
                               nil);                  // Nepedat nic do WM_CREATE
  if h_Wnd=0 then                                     // Pokud se okno nepodailo vytvoit
    begin
      KillGlWindow();                                 // Zru okno
      MessageBox(0,'Window creation error.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Vrt chybu
      exit;
    end;
  with pfd do                                         // Oznmme Windows jak chceme ve nastavit
    begin
      nSize:= SizeOf( TPIXELFORMATDESCRIPTOR );        // Velikost struktury
      nVersion:= 1;                                   // slo verze
      dwFlags:= PFD_DRAW_TO_WINDOW                    // Podpora okna
        or PFD_SUPPORT_OPENGL                         // Podpora OpenGL
        or PFD_DOUBLEBUFFER;                          // Podpora Double Bufferingu
      iPixelType:= PFD_TYPE_RGBA;                     // RGBA Format
      cColorBits:= bits;                              // Zvol barevnou hloubku
      cRedBits:= 0;                                   // Bity barev ignorovny
      cRedShift:= 0;
      cGreenBits:= 0;
      cBlueBits:= 0;
      cBlueShift:= 0;
      cAlphaBits:= 0;                                 // dn alpha buffer
      cAlphaShift:= 0;                                // Ignorovn Shift bit
      cAccumBits:= 0;                                 // dn akumulan buffer
      cAccumRedBits:= 0;                              // Akumulan bity ignorovny
      cAccumGreenBits:= 0;
      cAccumBlueBits:= 0;
      cAccumAlphaBits:= 0;
      cDepthBits:= 16;                                // 16-bitov hloubkov buffer (Z-Buffer)
      cStencilBits:= 1;                               // Stencil buffer (DLEIT)
      cAuxBuffers:= 0;                                // dn Auxiliary Buffer
      iLayerType:= PFD_MAIN_PLANE;                    // Hlavn vykreslovac vrstva
      bReserved:= 0;                                  // Rezervovno
      dwLayerMask:= 0;                                // Maska vrstvy ignorovna
      dwVisibleMask:= 0;
      dwDamageMask:= 0;
    end;
  h_Dc := GetDC(h_Wnd);                               // Zkus pipojit kontext zazen
  if h_Dc=0 then                                      // Podailo se pipojit kontext zazen?
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'Cant''t create a GL device context.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  PixelFormat := ChoosePixelFormat(h_Dc, @pfd);       // Zkus najt Pixel Format
  if (PixelFormat=0) then                             // Podailo se najt Pixel Format?
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'Cant''t Find A Suitable PixelFormat.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  if (not SetPixelFormat(h_Dc,PixelFormat,@pfd)) then  // Podailo se nastavit Pixel Format?
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'Cant''t set PixelFormat.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  h_Rc := wglCreateContext(h_Dc);                     // Podailo se vytvoit Rendering Context?
  if (h_Rc=0) then
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'Cant''t create a GL rendering context.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  if (not wglMakeCurrent(h_Dc, h_Rc)) then            // Podailo se aktivovat Rendering Context?
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'Cant''t activate the GL rendering context.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  ShowWindow(h_Wnd,SW_SHOW);                          // Zobrazen okna
  SetForegroundWindow(h_Wnd);                         // Do poped
  SetFOcus(h_Wnd);                                    // Zam fokus
  ReSizeGLScene(width,height);                        // Nastaven perspektivy OpenGL scny
  if (not InitGl()) then                              // Inicializace okna
    begin
      KillGLWindow();                                 // Zave okno
      MessageBox(0,'initialization failed.','Error',MB_OK or MB_ICONEXCLAMATION);
      Result:=false;                                  // Ukon program
      exit;
    end;
  Result:=true;                                       // Ve probhlo v podku
end;

procedure ProcessKeyboard;                                // Ovldn klvesnic
begin
  if keys[VK_RIGHT] then yrotspeed := yrotspeed + 0.08;   // ipka vpravo zv rychlost y rotace
  if keys[VK_LEFT] then yrotspeed := yrotspeed - 0.08;    // ipka vlevo sn rychlost y rotace
  if keys[VK_DOWN] then xrotspeed := xrotspeed + 0.08;    // ipka dol zv rychlost x rotace
  if keys[VK_UP] then xrotspeed := xrotspeed - 0.08;      // ipka nahoru sn rychlost x rotace
  if keys[Ord('A')] then zoom := zoom + 0.05;             // A pibl scnu
  if keys[Ord('Z')] then zoom := zoom - 0.05;             // Z oddl scnu
  if keys[VK_PRIOR] then height := height + 0.03;         // Page Up zvt vzdlenost me nad podlahou
  if keys[VK_NEXT] then height := height - 0.03;          // Page Down zmen vzdlenost me nad podlahou
end;

function WinMain(hInstance: HINST;                    // Instance
		 hPrevInstance: HINST;                            // Pedchoz instance
		 lpCmdLine: PChar;                                // Parametry pkazov dky
		 nCmdShow: integer):                              // Stav zobrazen okna
                        integer; stdcall;
var
  msg: TMsg;                                          // Struktura zprv systmu
  done: Bool;                                         // Promnn pro ukonen programu

begin
  done:=false;
  // Dotaz na uivatele pro fullscreen/okno
  {if MessageBox(0,'Would You Like To Run In FullScreen Mode?','Start FullScreen',
                             MB_YESNO or MB_ICONQUESTION)=IDNO then
    FullScreen:=false                                 // Bh v okn
  else
    FullScreen:=true;                                 // Fullscreen}
  FullScreen:=false;
  if not CreateGLWindow('NeHe''s OpenGL Framework',640,480,16,FullScreen) then // Vytvoen OpenGL okna
    begin
      Result := 0;                                    // Konec programu pi chyb
      exit;
    end;
  while not done do                                   // Hlavn cyklus programu
    begin
      if (PeekMessage(msg, 0, 0, 0, PM_REMOVE)) then  // Pila zprva?
        begin
          if msg.message=WM_QUIT then                 // Obdreli jsme zprvu pro ukonen?
            done:=true                                // Konec programu
          else
            begin
	          TranslateMessage(msg);                    // Pelo zprvu
	          DispatchMessage(msg);                     // Odele zprvu
	        end;
        end
      else      // Pokud nedola dn zprva
        begin
          // Je program aktivn, ale nelze kreslit? Byl stisknut ESC?
          if (active and not(DrawGLScene()) or keys[VK_ESCAPE]) then
            done:=true                                // Ukonme program
          else                                        // Pekreslen scny
            SwapBuffers(h_Dc);                        // Prohozen buffer (Double Buffering)
          if keys[VK_F1] then                         // Byla stisknuta klvesa F1?
            begin
            Keys[VK_F1] := false;                     // Ozna ji jako nestisknutou
            KillGLWindow();                           // Zru okno
            FullScreen := not FullScreen;             // Negace fullscreen
            // Znovuvytvoen okna
            CreateGLWindow('NeHe''s OpenGL Framework',640,480,16,fullscreen);
            //Result := 0;                            // Konec programu pokud nebylo vytvoeno
            end;
          ProcessKeyboard;                            // Vstup z klvesnice
        end;
    end;                                              // Konec smyky while
  killGLwindow();                                     // Zave okno
  result:=msg.wParam;                                 // Ukonen programu
end;

begin
  WinMain( hInstance, hPrevInst, CmdLine, CmdShow );   // Start programu
end.

