unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls;

type
  PMoves=^TMoves;
  TMoves=Array[0..0] of byte;
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Game1: TMenuItem;
    New1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    edtLevel: TEdit;
    Label1: TLabel;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    GameTimer: TTimer;
    Happy: TImage;
    Sad: TImage;
    edtCheat: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DoMove(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Moves: PMoves;
  MoveCount, MoveListSize, MoveIndex: Integer;
  Buttons: Array[1..4] of TShape;

implementation

{$R *.DFM}

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.New1Click(Sender: TObject);
var
  X, I: Integer;
  A: String;
begin
  try
    X := StrToInt(edtLevel.Text);
  except
    On EConvertError do
      begin
        MessageDlg(edtLevel.Text + ' is not a level index!',
          mtError, [mbOk], 0);
        Exit;
      end;
  end;
  Happy.Visible := True;
  If X > MoveListSize then
    begin
      If MoveListSize > 0 then
        FreeMem(Moves, MoveListSize);
      MoveListSize := X;
      GetMem(Moves, MoveListSize);
    end;
  MoveCount := X;
  MoveIndex := 0;
  {Flash first}
  Moves[0] := Random(4) + 1;
  Buttons[Moves[0]].Visible := False;
  Application.ProcessMessages;
  Sleep(100);
  Buttons[Moves[0]].Visible := True;
  For I := 1 to MoveCount - 1 do
    begin
      {flash I'th}
      Moves[I] := Random(4) + 1;
      While Moves[I] = Moves[I - 1] do
        Moves[I] := Random(4) + 1;
      Buttons[Moves[I]].Visible := False;
      Application.ProcessMessages;
      Sleep(100);
      Buttons[Moves[I]].Visible := True;
      Sleep(Random(300) + 200);
      Application.ProcessMessages;
    end;
  A := '';
  For I := 0 to MoveCount - 1 do
    A := A + IntToStr(Moves[I]) + ', ';
  edtCheat.Text := A;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  MoveListSize := 0;
  MoveIndex := -1;
  Randomize;
  Buttons[1] := Shape1;
  Buttons[2] := Shape2;
  Buttons[3] := Shape3;
  Buttons[4] := Shape4;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  If MoveListSize > 0 then
    FreeMem(Moves, MoveListSize);
end;

procedure TMainForm.DoMove(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  If MoveIndex = -1 then
    Exit;
  If TComponent(Sender).Tag = Moves[MoveIndex] then
    begin
      MoveIndex := MoveIndex + 1;
      If MoveIndex = MoveCount then
        ShowMessage('You win!');
    end
  else
    begin
      Happy.Visible := False;
      Sad.Visible := True;
      MoveIndex := -1;
    end;
end;

end.
