unit uNameForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, uDataForm;

type

  //Define our data structure
  PName = ^TName;
  TName = Packed Record
    IDNumber: Integer;
    LastName: String[80];
    FirstName: String[80];
    Other: Array[0..300] of Byte;
  end;

  TForm1 = class(TDataForm)
    Edit1: TEdit;
    Label1: TLabel;
    procedure Edit1Change(Sender: TObject);
    protected
      Function GetFieldCount: Integer; override;
      Procedure LoadFieldInfo(Index: Integer; var Field: TFieldInfo); override;
    private
      { Private declarations }
    public
      { Public declarations }
      Procedure GetControls; override;
      Function  GetFileName: String; override;
      Procedure PopulateControls; override;
      Function  RecordSize: Integer; override;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Procedure TForm1.GetControls;
var
  X: PName;
begin
  //This procedure is called just before it saves a record.
  //Do any special processing here by changing the DataPtr
  X := PName(DataPtr);
  X^.LastName := Edit1.Text;
end;

Function TForm1.GetFieldCount: Integer;
begin
  //MUST return correct number of fields (or lockup)
  Result := 3;
end;

Function TForm1.GetFileName: String;
begin
  //Datafile
  Result := 'MyInfo.dat';
end;

Procedure TForm1.LoadFieldInfo(Index: Integer; var Field: TFieldInfo);
begin
  //MUST correctly define all fields to be used
  //Gaps can be left at the end for future changes
  Case Index of
    0:
      begin
        Field.FieldName := 'ID';
        Field.FieldType := dt_AutoNumber;
        Field.FieldSize := 4;
        //Field.Visible := False;
      end;
    1:
      begin
        Field.FieldName := 'LastName';
        Field.FieldType := dt_String;
        Field.FieldSize := 80;
      end;
    2:
      begin
        Field.FieldName := 'FirstName';
        Field.FieldType := dt_String;
        Field.FieldSize := 80;
      end;
  end;
end;

Procedure TForm1.PopulateControls;
var
  X: PName;
begin
  //Called just after a record is read into DataPtr
  //Before the grid attemps to display

  X := PName(DataPtr);
  //edtD.Text := IntToStr(X^.ID);
  Edit1.Text := X^.LastName;
end;

Function TForm1.RecordSize: Integer;
begin
  Result := Sizeof(TName);
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  //If not nodified := true, your changes will not be saved
  //The grid automatically sets modified
  Modified := True;
end;

end.
