Unit uDataForm;

{This is the base DataForm Module v0.9

To use, ALWAYS override

  GetFileName
  GetRecordSize
  Function GetFieldCount
  Procedure LoadFieldInfo

you should also override

  Procedure GetControls; override;
  Procedure PopulateControls; override;

but the system will function without them. See the sample for more

}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, mStrin32, stdCtrls, Grids;

type

  TViewType = (
    vt_FormView,   //As form
    vt_ListView    //DBGrid
    );

  EDataError = Class(Exception);

  TDataForm=Class;

  //****************************************************
  //Fields
  //****************************************************
  TDataType =
    (dt_None,       //Undeclared Field Type. Do not use
     dt_Integer,    //All Integral types. No accomodation for bytes
     dt_String,     //ShortString
     dt_Float,      //
     dt_AutoNumber  //Automatically increases using ANum from InitData
     );
  TFieldInfo = Record
    FieldName: String[60];
    FieldType: TDataType;
    FieldSize: Integer; //Valid only for varString, max 255
    Visible:   Boolean;
  end;
  PFieldList=^TFieldList;
  TFieldList=Array[0..0] of TFieldInfo;

  //****************************************************
  //Indices
  //****************************************************

  //Generic Index
  PIndice=^TIndice;
  TIndice=Packed Record
    TrueRecNo: Integer;
    Data: Array[0..7] of Char;
  end;
  //Integral Index
  PIndiceI=^TIndiceI;
  TIndiceI=Packed Record
    TrueRecNo: Integer;
    Data: Integer;
    Other: Array[0..3] of byte;
  end;
  //Float
  PIndiceF=^TIndiceF;
  TIndiceF=Packed Record
    TrueRecNo: Integer;
    Data: Double
  end;
  //String
  PIndiceS=^TIndiceS;
  TIndiceS=Packed Record
    TrueRecNo: Integer;
    Data: Array[0..7] of Char;
  end;
  PIndex=^TIndex;
  TIndex=Array[0..0] of TIndice;

  //****************************************************
  //DataGrid
  //****************************************************

  TDataGrid=Class(TStringGrid)
    private
      Form: TDataForm;
      Function GetPage: Integer;
      procedure WMVScroll(var Message: TWMVScroll); message WM_VSCROLL;
      Property Page: Integer read GetPage;
    protected
      procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LButtonDown;
      procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LButtonUp;
    public
      procedure WndProc(var Message: TMessage); override;
  end;


  //****************************************************
  //DataForm
  //****************************************************

  TInitialData=Packed Record
    ANum: Integer;
    Other: Array[0..1016] of byte;
  end;

  TDataForm = class(TForm)
    private
      fBOF, fEOF: Boolean;
      fRecNo: Integer;
      Fg, Lg, Cg: Integer; //First&Last -Grid
      FH: THandle;
      FieldList: PFieldList;
      Inserting: Boolean;
      MainIndex: PIndex;
      MainIndexOk: Boolean;
      MainIndexSize: Integer;
      Ok: Boolean;
      SavedWidth: Integer;
      Selecting: Boolean;
      Sg: TDataGrid;
      SortField: Integer;
      TempPtr: Pointer;
      Procedure BuildIndex;
      Procedure DoSort;
      Procedure DrawGrid(Sender: TObject; Col, Row: Longint;
                Rect: TRect; State: TGridDrawState);
      //Function  GetCols(Index: Integer): String;
      Function  GetColWidths(Index: Integer): Integer;
      Function  GetCurrentIndex: PIndex;
      Function  GetViewType: TViewType;
      Procedure LoadGrid;
      Procedure LoadRecord(Index: Integer);
      Procedure gdMoveToCurrentRecord;
      Procedure gdSelect(Sender: TObject; Col, Row: Longint; var CanSelect: Boolean);
      Procedure gdSetEditText(Sender: TObject; ACol, ARow: Longint; const Value: string);
      Procedure RefreshSYSMenu;
      //Procedure SetCols(Index: Integer; Value: String);
      Procedure SetColWidths(Index: Integer; Value: Integer);
      Procedure SetViewType(AView: TViewType);
    protected
      Function  Compare(A, B: Pointer; SortField: Integer): Boolean; virtual;
      Procedure DoSave; virtual;
      Function  FieldToCol(FieldIndex: Integer): Integer;
      Function  GetFieldCount: Integer; virtual;
      Function  GetFieldData(Index: Integer; Rec: Pointer): Variant;
      Function  GetFieldNames(Index: Integer): String; virtual;
      Function  GetRecordCount: Integer; virtual;
      Procedure LoadFieldInfo(Index: Integer; var Field: TFieldInfo); virtual;
      Procedure SetFieldData(Index: Integer; Data: Pointer; DataLen: Integer);
    public
      DataPtr: Pointer;
      Modified: Boolean;
      Constructor Create(AOwner: TComponent); override;
      Procedure Delete;
      Destructor Destroy; override;
      //Procedure AddIndex(FieldNo, IndexType: Integer);
      Procedure First;
      Procedure GetControls; virtual;
      //Procedure GetRows(Data: Pointer); virtual;
      Function  GetFileName: String; virtual;
      Procedure Insert;
      Procedure Last;
      Procedure Next;
      Procedure Open;
      Procedure PopulateControls; virtual;
      Procedure Previous;
      Function  RecordSize: Integer; virtual;
      Procedure SortBy(FieldNo: Integer);
      procedure WndProc(var Message: TMessage); override;
      property  BOF: Boolean read fBOF;
      //property  Cols[Index: Integer]: String read GetCols write SetCols;
      property  ColWidths[Index: Integer]: Integer read GetColWidths write SetColWidths;
      property  EOF: Boolean read fEOF;
      property  FieldCount: Integer read GetFieldCount;
      property  FieldNames[Index: Integer]: String read GetFieldNames;
      property  RecordCount: Integer read GetRecordCount;
      property  View: TViewType read GetViewType write SetViewType;
  end;

const
  SzInitialData     = Sizeof(TInitialData);
  wm_LoadFirst      = wm_User + 1;

  wm_ListView       = 1;
  wm_FormView       = 2;

implementation

Function ReadFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';
Function WriteFile(H: THandle; Buffer: Pointer; Num: DWord; Written: PDWord; Ov: Pointer): Boolean; Stdcall; external 'kernel32.dll';

Function TDataGrid.GetPage: Integer;
begin
  Result := (ClientHeight div DefaultRowHeight) - 2;
end;

procedure TDataGrid.WMLButtonDown(var Message: TWMLButtonUp);
begin
  Inherited;
end;

procedure TDataGrid.WMLButtonUp(var Message: TWMLButtonUp);
var
  P: TGridCoord;
begin
  Inherited;
  P := MouseCoord(Message.XPos, Message.YPos);
  If P.Y = 0 then
    Form.SortBy(P.X - 1);
end;

procedure TDataGrid.WndProc(var Message: TMessage);
var
  SavedCol: Integer;

  Procedure ClearMsg;
  begin
    Message.Result := 1;
    Message.wParam := 0;
  end;
begin
  Case Message.Msg of
    cm_ChildKey:
      If GetKeyState(Message.wParam) AND $10000000 = $10000000 then
        begin
          Case Message.wParam of
            vk_TAB:
              begin
                If GetKeyState(vk_Shift) AND $10000000 = $10000000 then
                  begin
                    If Col = 1 then
                      begin
                        Form.Previous;
                        Col := ColCount - 1;
                        ClearMsg;
                      end;
                  end
                else
                  If Col = ColCount - 1 then
                    begin
                      Form.Next;
                      ClearMsg;
                    end;
              end;
            vk_Down:
              begin
                If Row = RowCount - 1 then
                  begin
                    SavedCol := Col;
                    Form.Next;
                    Col := SavedCol;
                    ClearMsg;
                  end;
              end;
            vk_Up:
              begin
                If Row = 1 then
                  begin
                    SavedCol := Col;
                    Form.Previous;
                    Col := SavedCol;
                    ClearMsg;
                  end;
              end;
            vk_Next:
              begin
                SavedCol := Col;
                Form.LoadRecord(Form.fRecNo + Page);
                Col := SavedCol;
                ClearMsg;
              end;
            vk_Prior:
              begin
                SavedCol := Col;
                Form.LoadRecord(Form.fRecNo - Page);
                Col := SavedCol;
                ClearMsg;
              end;
          end;
        end;
  end;
  Inherited WndProc(Message);
end;

procedure TDataGrid.WMVScroll(var Message: TWMHScroll);
begin
  Inherited;
  case Message.ScrollCode of
    SB_LINEUP: Form.Previous;
    SB_LINEDOWN: Form.Next;
    SB_PAGEUP: Form.LoadRecord(Form.fRecNo - Page);
    SB_PAGEDOWN: Form.LoadRecord(Form.fRecNo + Page);
    SB_THUMBPOSITION: Form.LoadRecord(Message.Pos);
    SB_THUMBTRACK: Form.LoadRecord(Message.Pos);
    SB_TOP: Form.First;
    SB_BOTTOM: Form.Last;
    SB_ENDSCROLL: begin end;
  end;
end;

Constructor TDataForm.Create(AOwner: TComponent);
var
  T: TInitialData;
  W: DWord;
  H: THandle;
  I, C: Integer;
begin
  //Indexes
  //AddIndex(-1, 0);
  MainIndexOk := False;

  Inherited Create(AOwner);
  fBOF := True;
  fEOF := True;
  Selecting := False;
  SortField := -1;
  H := GetSystemMenu(Handle, False);
  DeleteMenu(H, GetMenuItemCount(H) - 2, mf_ByPosition);
  DeleteMenu(H, SC_Close, mf_ByCommand);
  DeleteMenu(H, GetMenuItemCount(H) - 2, mf_ByPosition);
  AppendMenu(H, mf_Separator, 0, '');
  AppendMenu(H, 0, wm_ListView, 'View As List');
  AppendMenu(H, 0, wm_FormView, 'View As Form');
  Fh := CreateFile(
    PChar(My_FileDirectory(ParamStr(0)) + GetFileName),
    Generic_Read OR Generic_Write,
    File_Share_Read or File_Share_Write,
    nil, Open_Always, 0, 0);
  If Fh = Invalid_Handle_Value then
    begin
      Ok := False;
      Caption := 'Load Error ' + Caption;
      Exit;
    end;
  Ok := True;
  GetMem(FieldList, Sizeof(TFieldInfo) * FieldCount);
  For I := 0 to FieldCount - 1 do
    begin
      FieldList^[I].Visible := True;
      LoadFieldInfo(I, FieldList^[I]);
    end;
  GetMem(DataPtr, RecordSize);
  GetMem(TempPtr, RecordSize);
  If GetFileSize(Fh, nil) = 0 then
    begin
      FillChar(T, Sizeof(TInitialData), #0);
      WriteFile(Fh, @T, szInitialData, @W, nil);
    end;
  fRecNo := 0;
  Inserting := False;
  Modified := False;
  Sg := TDataGrid.Create(Self);
  Sg.Parent := Self;
  Sg.Form := Self;
  Sg.Visible := False;
  C := 1;
  For I := 0 to FieldCount - 1 do
    If FieldList^[I].Visible then
      Inc(C);
  Sg.ColCount := C;
  Sg.ColWidths[0] := 10;
  Sg.BorderStyle := bsNone;
  Sg.DefaultRowHeight := ABS(Sg.Font.Height) + 5;
  Sg.Options := [goEditing, goDrawFocusSelected,
    goColSizing, goTabs, goVertLine, goHorzLine,
    goFixedVertLine, goFixedHorzLine];
  Sg.ScrollBars := ssHorizontal;
  Sg.OnDrawCell := DrawGrid;
  Sg.OnSelectCell := gdSelect;
  Sg.OnSetEditText := gdSetEditText;

  Fg := 0;
  Lg := 0;
  PostMessage(Handle, wm_LoadFirst, 0, 0);

  BuildIndex;
end;

{Procedure TDataForm.AddIndex(FieldNo, IndexType: Integer);
var
  OldCount: Integer;
  OldIndex: PIndexList;
begin
  OldCount := IndexCount;
  OldIndex := IndexList;
  Inc(IndexCount);
  GetMem(IndexList, Sizeof(TIndexList) * IndexCount);

  If OldCount > 0 then
    begin
      Move(OldIndex^, IndexList^, Sizeof(TIndexList) * OldCount);
      FreeMem(OldIndex, Sizeof(TIndexList) * OldCount);
    end;

  IndexList^[IndexCount - 1].FieldNo := FieldNo;
  IndexList^[IndexCount - 1].FieldType := IndexType;
  IndexList^[IndexCount - 1].IndexSize := 0;
end;}

Procedure TDataForm.BuildIndex;
var
  Buffer: Array[0..4096] of byte;
  I, S: Integer;
  P: Variant;
  W: DWord;
  A: String;
begin
  If MainIndexOk then Exit;

  //G := GetCurrentIndex;
  //Is the Index big enough to hold all the Records?
  If MainIndexSize < RecordCount then
    begin
      If MainIndexSize > 0 then
        FreeMem(MainIndex, MainIndexSize * Sizeof(TIndice));
      MainIndexSize := RecordCount;
      GetMem(MainIndex, MainIndexSize * Sizeof(TIndice));
    end;
  //Clear the MainIndex
  For I := 0 to MainIndexSize - 1 do
    MainIndex^[I].TrueRecNo := -1;
  //Fill the MainIndex with the record numbers And Data
  SetFilePointer(Fh, szInitialData, nil, File_Begin);

  S := 0;
  If SortField > -1 then
    S := SortField;

  For I := 0 to MainIndexSize - 1 do
    begin
      MainIndex^[I].TrueRecNo := I;
      ReadFile(Fh, @Buffer, RecordSize, @W, nil);
      P := GetFieldData(S, @Buffer);
      Case varType(P) of
        varString:
          begin
            A := LowerCase(P);
            W := Length(A);
            If W > 7 then
              W := 7;
            StrLCopy(TIndiceS(MainIndex^[I]).Data, PChar(A), W);
          end;
        varInteger: TIndiceI(MainIndex^[I]).Data := P;
      end;
    end;
  MainIndexOk := True;
end;

Function TDataForm.Compare(A, B: Pointer; SortField: Integer): Boolean;
var
  X, Y: Variant;
begin
  X := GetFieldData(SortField, A);
  Y := GetFieldData(SortField, B);
  If VarType(X) = varString then
    X := LowerCase(X);
  If VarType(Y) = varString then
    Y := LowerCase(Y);
  If X <= Y then
   Result := True
  else
    Result := false;
end;

Procedure TDataForm.Delete;
var
  H: THandle;
  I, E: Integer;
  W: DWord;
begin
  CloseHandle(Fh);
  H := CreateFile(
    PChar(My_FileDirectory(ParamStr(0)) + GetFileName),
    Generic_Read OR Generic_Write, File_Share_Read,
    nil, Open_Always, 0, 0);
  If H = Invalid_Handle_Value then
    begin
      Ok := False;
      E := GetLastError;
      Fh := CreateFile(
        PChar(My_FileDirectory(ParamStr(0)) + GetFileName),
        Generic_Read OR Generic_Write,
        File_Share_Read or File_Share_Write,
        nil, Open_Always, 0, 0);
      If E = 32 then
        Raise EDataError.Create('Cannot delete record because another DataForm has the datafile open.');
      Raise EDataError.Create('Cannot delete record. GetLastError() reports #' + IntToStr(E));
    end;
  For I := fRecNo + 1 to RecordCount - 1 do
    begin
      SetFilePointer(Fh, szInitialData + I * RecordSize, nil, File_Begin);
      ReadFile(Fh, DataPtr, RecordSize, @W, nil);
      SetFilePointer(Fh, szInitialData + (I - 1) * RecordSize, nil, File_Begin);
      WriteFile(Fh, DataPtr, RecordSize, @W, nil);
    end;
  SetFilePointer(Fh, szInitialData + (RecordCount - 1) * RecordSize, nil, File_Begin);
  SetEndOfFile(H);
  CloseHandle(H);
  Fh := CreateFile(
    PChar(My_FileDirectory(ParamStr(0)) + GetFileName),
    Generic_Read OR Generic_Write,
    File_Share_Read or File_Share_Write,
    nil, Open_Always, 0, 0);
  If fRecNo = RecordCount then
    Dec(fRecNo);
  MainIndexOk := False;
  LoadRecord(fRecNo);
end;

Destructor TDataForm.Destroy;
begin
  If Modified then
    DoSave;
  Inherited Destroy;
  If Ok then
    begin
      CloseHandle(Fh);
      FreeMem(DataPtr, RecordSize);
      FreeMem(TempPtr, RecordSize);
      FreeMem(FieldList, Sizeof(TFieldInfo) * FieldCount);
    end;
  If MainIndexSize > 0 then
    FreeMem(MainIndex, MainIndexSize * Sizeof(TIndex));
end;

Procedure TDataForm.DoSave;
var
  W: DWord;
  Rn, I, J, S: Integer;
  A: String;
  Ig: Boolean;
  T: TInitialData;
  P: Variant;
begin
  Ig := Inserting;
  Inserting := False;
  If (fRecNo < 0) OR not Ok OR not Modified then
    Exit;
  If Ig then
    begin
      SetFilePointer(Fh, 0, nil, File_Begin);
      ReadFile(Fh, @T, szInitialData, @W, nil);
    end;
  if Sg.Visible then
    begin
      For I := 0 to FieldCount - 1 do
        If FieldList^[I].Visible then
        Case FieldList^[I].FieldType of
          dt_String:
            begin
              //A := Sg.Cells[FieldToCol(I) + 1, fRecNo - Fg + 1];
              A := Sg.Cells[FieldToCol(I) - 1, fRecNo - Fg + 1];
              SetFieldData(I, PChar(A), Length(A));
            end;
          dt_Integer:
            begin
              try
                J := StrToInt(Sg.Cells[FieldToCol(I)- 1, fRecNo - Fg + 1]);
              except
                On Exception do Continue;
              end;
              SetFieldData(I, @J, 4);
            end;
          dt_AutoNumber:
            begin
              If Ig then
                begin
                  J := T.ANum;
                  SetFieldData(I, @J, 4);
                  Continue;
                end;
              Try
                J := StrToInt(Sg.Cells[FieldToCol(I)-1, fRecNo - Fg + 1]);
              except
                On Exception do Continue;
              end;
              SetFieldData(I, @J, 4);
            end;
        end;
    end
  else
    GetControls;
  RN := fRecNo;
  //RN := fRecNo - Fg;
  If SortField > -1 then
    RN := GetCurrentIndex^[fRecNo].TrueRecNo;
  If Ig then
    begin
      Inc(T.ANum);
      SetFilePointer(Fh, 0, nil, File_Begin);
      WriteFile(Fh, @T, szInitialData, @W, nil);
    end;
  SetFilePointer(Fh, szInitialData + RN * RecordSize, nil, File_Begin);
  WriteFile(Fh, DataPtr, RecordSize, @W, nil);
  Modified := False;

  //Refill this entry in the Index
  S := 0;
  If SortField > -1 then
    S := SortField;
  //MainIndex^[fRecNo].TrueRecNo := Rn;
  //ReadFile(Fh, @Buffer, RecordSize, @W, nil);
  P := GetFieldData(S, DataPtr);
  Case varType(P) of
    varString:
      begin
        A := LowerCase(P);
        W := Length(A);
        If W > 7 then
          W := 7;
        StrLCopy(TIndiceS(MainIndex^[fRecNo]).Data, PChar(A), W);
      end;
    varInteger: TIndiceI(MainIndex^[fRecNo]).Data := P;
  end;

end;

Procedure TDataForm.DoSort;
var
  Busy: Boolean;
  //A, B: Pointer;
  I, S: Integer;
  T: TIndice;
  //W: DWord;
  //G: PIndex;

  Function IsWrong(X: Integer): Boolean;
  begin
    IsWrong := False;
    Case FieldList[S].FieldType of
      dt_Integer, dt_AutoNumber:
        If TIndiceI(MainIndex^[X]).Data > TIndiceI(MainIndex^[X + 1]).Data then
          IsWrong := True;
      dt_String:
        If TIndiceS(MainIndex^[X]).Data > TIndiceS(MainIndex^[X + 1]).Data then
          IsWrong := True;
    end;
  end;

begin
  BuildIndex;
  //G := GetCurrentIndex;
  //GetMem(A, RecordSize);
  //GetMem(B, RecordSize);
  //Temporary Bubble Sort to be replaced
  //with Insertion Sort
  S := 0;
  If SortField > -1 then
    S := SortField;
  Busy := True;
  While Busy do
    begin
      Busy := False;
      For I := 0 to MainIndexSize - 2 do
        If IsWrong(I) then
          begin
              T := MainIndex^[I];
              MainIndex^[I] := MainIndex^[I + 1];
              MainIndex^[I + 1] := T;
              Busy := True;
          end;
      {For I := 0 to MainIndexSize - 2 do
        begin
          SetFilePointer(Fh, szInitialData + G^[I].TrueRecNo * RecordSize, nil, File_Begin);
          ReadFile(Fh, A, RecordSize, @W, nil);
          SetFilePointer(Fh, szInitialData + G^[I + 1].TrueRecNo * RecordSize, nil, File_Begin);
          ReadFile(Fh, B, RecordSize, @W, nil);
          If not Compare(A, B, SortField) then
            begin
              T := G^[I].TrueRecNo;
              G^[I].TrueRecNo := G[I + 1].TrueRecNo;
              G^[I + 1].TrueRecNo := T;
              Busy := True;
            end;
          If G^[I].TrueRecNo = -1 then
            Break;
        end;}
    end;
  //FreeMem(A, RecordSize);
  //FreeMem(B, RecordSize);
end;

Procedure TDataForm.DrawGrid(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var
  A: Array[1..3] of TPoint;
  L, R, T, B, M: Integer;
begin
  If (Row = fRecNo - Fg + 1) AND (Col = 0) AND not Inserting then
    begin
      TStringGrid(Sender).Canvas.Brush.Color := clBlack;
      A[1].X := Rect.Left + 1;
      A[1].Y := Rect.Top;
      A[2].X := Rect.Right - Rect.Left - 1;
      A[2].Y := Rect.Top + (Rect.Bottom - Rect.Top) div 2;
      A[3].X := Rect.Left + 1;
      A[3].Y := Rect.Top + (Rect.Bottom - Rect.Top);
      TStringGrid(Sender).Canvas.Polygon(A);
    end;
  If (Row = Sg.RowCount - 1) AND (Col = 0) AND (Inserting) then
    begin
      TStringGrid(Sender).Canvas.Pen.Color := clBlack;
      L := Rect.Left + 2;
      R := Rect.Right - Rect.Left - 2;
      T := Rect.Top;
      B := Rect.Top + (Rect.Bottom - Rect.Top);
      M := (T + B) div 2;
      //TStringGrid(Sender).Canvas.TextOut(Rect.Left + 1, Rect.Top, 'R');
      TStringGrid(Sender).Canvas.Moveto(L, T);
      TStringGrid(Sender).Canvas.Lineto(R, B);
      TStringGrid(Sender).Canvas.Moveto(L, B);
      TStringGrid(Sender).Canvas.Lineto(R, T);
      TStringGrid(Sender).Canvas.Moveto(L, M);
      TStringGrid(Sender).Canvas.Lineto(R, M);
    end;
end;

Function TDataForm.FieldToCol(FieldIndex: Integer): Integer;
var
  C, I: Integer;
begin
  Result := 0;
  C := 1;
  For I := 0 to FieldCount - 1 do
    begin
      If FieldList^[I].Visible then
        Inc(C);
      If I = FieldIndex then
        begin
          Result := C;
          Break;
        end;
    end;
end;

Procedure TDataForm.First;
begin
  LoadRecord(0);
end;

{Function TDataForm.GetCols(Index: Integer): String;
begin
  Result := Sg.Cells[Index + 1, fRecNo + 1];
end;}

Function TDataForm.GetColWidths(Index: Integer): Integer;
begin
  Result := Sg.ColWidths[Index + 1];
end;

Procedure TDataForm.GetControls;
begin

end;

Function TDataForm.GetCurrentIndex: PIndex;
begin
  Result := MainIndex;
end;

Function TDataForm.GetFieldCount: Integer;
begin
  Result := 0;
end;

Function TDataForm.GetFieldData(Index: Integer; Rec: Pointer): Variant;
var
  V: Variant;
  S: ShortString;
  Si: Integer;
  I, Total: Integer;
  Pi: PInteger;
  Bp: PByte;
begin
  Total := 0;
  For I := 0 to Index - 1 do
    Case FieldList^[I].FieldType of
      dt_AutoNumber, dt_Integer: Total := Total + 4;
      dt_String: Total := Total + FieldList^[I].FieldSize + 1;
      //varDouble
    end;
  Rec := Pointer( Integer(Rec) + Total);
  Case FieldList^[Index].FieldType of
    dt_String:
      begin
        Bp := Pointer( Integer(Rec) );
        Move(Rec^, S, Bp^ + 1);
        V := S;
      end;
    dt_AutoNumber, dt_Integer:
      begin
        Pi := Rec;
        Si := Pi^;
        V := Si;
      end;
    else
      V := '';
  end;
  Result := V;
end;

Function TDataForm.GetFieldNames(Index: Integer): String;
begin
  Result := '';
  If (Index >= 0) AND (Index < FieldCount) then
    Result := FieldList^[Index].FieldName;
end;

Function TDataForm.GetFileName: String;
begin
  Result := 'blank.dat';
end;

Function TDataForm.GetRecordCount: Integer;
begin
  Result := (GetFileSize(Fh, nil) - szInitialData)
    div RecordSize;
end;

{Procedure TDataForm.GetRows(Data: Pointer);
begin
end;}

Function TDataForm.GetViewType: TViewType;
begin
  Result := vt_FormView;
  If Sg.Visible then
    Result := vt_ListView;
end;

Procedure TDataForm.gdMoveToCurrentRecord;
begin
  //Place
  If fRecNo - Fg >= 0 then
    begin
      If fRecNo - Fg + 1 < Sg.RowCount then
        Sg.Row := fRecNo - Fg + 1;
      Sg.Col := 1;
      Sg.Repaint;
    end;
end;

Procedure TDataForm.gdSelect(Sender: TObject; Col, Row: Longint; var CanSelect: Boolean);
begin
  If Selecting then Exit;
  Selecting := True;
  If (Row > -1) AND (Row <= RecordCount) then
    LoadRecord(Fg + Row - 1);
  Selecting := False;
end;

Procedure TDataForm.gdSetEditText(Sender: TObject; ACol, ARow: Longint; const Value: string);
begin
  Modified := True;
end;

Procedure TDataForm.Insert;
var
  I: Integer;
begin
  FillChar(DataPtr^, RecordSize, #0);
  If Sg.Visible then
    begin
      Last;
      Sg.RowCount := Sg.RowCount + 1;
      Sg.Row := Sg.Row + 1;
      For I := 0 to Sg.ColCount - 1 do
        Sg.Cells[I, Sg.Row] := '';
    end;
  fRecNo := RecordCount;
  Inserting := True;
  MainIndexOk := False;
  PopulateControls;
  Modified := False;
end;

Procedure TDataForm.Last;
begin
  If not EOF then
    LoadRecord(RecordCount - 1);
end;

Procedure TDataForm.LoadFieldInfo(Index: Integer; var Field: TFieldInfo);
begin
  Field.FieldName := '';
  Field.FieldType := dt_None;
  Field.FieldSize := 0;
end;

Procedure TDataForm.LoadGrid;
var
  Buffer: Array[0..4096] of byte;
  I, J, Count: Integer;
  W: DWord;
  SavedRecNo: Integer;
  X: TScrollInfo;
  P: Variant;
  //P1: Pointer;
begin
  //Last Point
  Lg := Fg + Sg.Page;
  If Lg > RecordCount then
    Lg := RecordCount;
  Count := Lg - Fg + 1;
  If Count < 2 then
    Count := 2;
  If not (Count = Sg.RowCount) then
    Sg.RowCount := Count;
  //Fill
  Cg := 0;
  SavedRecNo := fRecNo;
  For I := Fg to Lg do
    begin
      If SortField > -1 then
        fRecNo := GetCurrentIndex^[I].TrueRecNo
      else
        fRecNo := I;
      SetFilePointer(Fh, szInitialData + fRecNo * RecordSize, nil, File_Begin);
      //ReadFile(Fh, TempPtr, RecordSize, @W, nil);
      //FillChar(Buffer, 4096, #0);
      ReadFile(Fh, @Buffer, RecordSize, @W, nil);
      //Fill the row
      //PopulateRow(TempPtr);
      //P1 := @Buffer;
      //Move(Buffer, J, 4);
      //P1 := Pointer(P1^);
      //Cols[0] := IntToStr(J);
      For J := 0 to FieldCount - 1 do
        If FieldList^[J].Visible then
        begin
          //P := GetFieldData(J, TempPtr);
          P := GetFieldData(J, @Buffer);
          Case varType(P) of
            //varString: Cols[J] := P;
            varString: Sg.Cells[FieldToCol(J) - 1, Cg + 1] := P;
            //varInteger: Cols[J] := IntToStr(P);
            varInteger: Sg.Cells[FieldToCol(J) - 1, Cg + 1] := IntToStr(P);
          end;
        end;
      Inc(Cg);
    end;
  fRecNo := SavedRecNo;
  //Scrolling
  If (Fg > 0) OR (Lg < RecordCount) then
    begin
      ShowScrollBar(Sg.Handle, sb_Vert, True);
      EnableScrollBar(Sg.Handle, sb_Vert, ESB_Enable_Both);
      X.cbSize := Sizeof(TScrollInfo);
      X.fMask := SIF_Page or SIF_Pos OR SIF_Range;
      X.nPage  := 1;
      X.nMin := 0;
      X.nMax := GetRecordCount;
      X.nPos := fRecNo;
      SetScrollInfo(Sg.Handle, sb_Vert, X, True);
    end
  else
    ShowScrollBar(Sg.Handle, sb_Vert, False);
end;

Procedure TDataForm.LoadRecord(Index: Integer);
var
  W: DWord;
  Max: Integer;
begin
  If not Ok then
    Exit;
  If Index < 0 then
    Index := 0;
  If Modified then
    DoSave;
  Inserting := False;

  //Let's check for grid motion
  Max := Sg.Page;
  If Index < fRecNo then
    begin
      If Fg > Index then
        Fg := Index;
    end;
  If Index > fRecNo then
    begin
      If Fg < Index then
        If Fg + Max <= Index then
          Fg := Index - Max + 1;
    end;
  fRecNo := Index;
  SetFilePointer(Fh, szInitialData + Index * RecordSize, nil, File_Begin);
  ReadFile(Fh, DataPtr, RecordSize, @W, nil);
  If fRecNo = 0 then
    fBOF := True
  else
    fBOF := False;
  If fRecNo < RecordCount - 1 then
    fEOF := False
  else
    fEOF := True;
  PopulateControls;
  //If W < RecordSize then
  Modified := False;
  If Sg.Visible then
    begin
      LoadGrid;
      gdMoveToCurrentRecord;
    end;
end;

Procedure TDataForm.Next;
begin
  If not EOF then
    LoadRecord(fRecNo + 1);
end;

Procedure TDataForm.Open;
begin
  Fh := CreateFile(
    PChar(My_FileDirectory(ParamStr(0)) + GetFileName),
    Generic_Read OR Generic_Write,
    File_Share_Read or File_Share_Write,
    nil, Open_Always, 0, 0);
end;

Procedure TDataForm.PopulateControls;
begin

end;

Procedure TDataForm.Previous;
begin
  If not BOF then
    LoadRecord(fRecNo - 1);
end;

Function TDataForm.RecordSize: Integer;
begin
  Result := 0;
end;

Procedure TDataForm.RefreshSYSMenu;
var
  H: THandle;
begin
  H := GetSystemMenu(Handle, False);
  If Sg.Visible then
    begin
      EnableMenuItem(H, wm_ListView, mf_Grayed);
      EnableMenuItem(H, wm_FormView, mf_Enabled);
    end
  else
    begin
      EnableMenuItem(H, wm_ListView, mf_Enabled);
      EnableMenuItem(H, wm_FormView, mf_Grayed);
    end
end;

{Procedure TDataForm.SetCols(Index: Integer; Value: String);
begin
  Sg.Cells[Index + 1, Cg + 1] := Value;
end;}

Procedure TDataForm.SetColWidths(Index: Integer; Value: Integer);
begin
  Sg.ColWidths[Index + 1] := Value;
end;

Procedure TDataForm.SetFieldData(Index: Integer; Data: Pointer; DataLen: Integer);
var
  I, Total: Integer;
  D: Pointer;
  S: ShortString;
begin
  Total := 0;
  For I := 0 to Index - 1 do
    Case FieldList^[I].FieldType of
      dt_AutoNumber, dt_Integer: Total := Total + 4;
      dt_String: Total := Total + FieldList^[I].FieldSize + 1;
      //varDouble
    end;
  D := Pointer( Integer(DataPtr) + Total);
  Case FieldList^[Index].FieldType of
    dt_String:
    begin
      S := StrPas(Data);
      Move(S, D^, DataLen + 1);
      //Move(Data^, D^, DataLen);
    end;
    dt_AutoNumber, dt_Integer:
      Move(Data^, D^, 4);
  end;

end;

Procedure TDataForm.SetViewType(AView: TViewType);
begin
  Case AView of
    vt_FormView: PostMessage(Handle, wm_SYSCommand, wm_FormView, 0);
    vt_ListView: PostMessage(Handle, wm_SYSCommand, wm_ListView, 0);
  end;
end;

Procedure TDataForm.SortBy(FieldNo: Integer);
begin
  If not Ok then
    Exit;
  If Modified then
    DoSave;
  If not (SortField = FieldNo) then
    MainIndexOk := False;
  SortField := FieldNo;
  DoSort;
  LoadRecord(fRecNo);
end;

procedure TDataForm.WndProc(var Message: TMessage);
var
  I: Integer;
  Tw: Integer;
  X: TScrollInfo;

  Procedure HideAllControls;
  var
    X: Integer;
  begin
    For X := 0 to ComponentCount - 1 do
      If Components[X] is TControl then
        TControl(Components[X]).Visible := False;
  end;

  Procedure ShowAllControls;
  var
    X: Integer;
  begin
    For X := 0 to ComponentCount - 1 do
      If Components[X] is TControl then
        TControl(Components[X]).Visible := True;
  end;

begin
  Inherited WndProc(Message);
  Case Message.Msg of
    wm_LoadFirst:
      begin
        LoadRecord(0);
        For I := 0 to FieldCount - 1 do
          If FieldList^[I].Visible then
            Sg.Cells[FieldToCol(I) - 1, 0] := FieldNames[I];
        RefreshSYSMenu;
      end;
    wm_Size:
      If not (Sg = nil) then
        If Sg.Visible then
          begin
            LoadGrid;
            {Tw := 5;
            For I := 0 to GetFieldCount do
              Tw := Tw + Sg.ColWidths[I];
            If ClientWidth < Tw then
              begin
                ShowScrollBar(Sg.Handle, sb_Horz, True);
                EnableScrollBar(Sg.Handle, sb_Horz, ESB_Enable_Both);
                end
            else
              begin
                ShowScrollBar(Sg.Handle, sb_Horz, False);
                EnableScrollBar(Sg.Handle, sb_Horz, ESB_Enable_Both);
              end;}
          end;
    wm_SysCommand:
      Case Message.WParam of
        wm_ListView:
          begin
            HideAllControls;
            Sg.Align := alClient;
            Tw := 0;
            For I := 0 to GetFieldCount do
              Tw := Tw + Sg.ColWidths[I];
            SavedWidth := Width;
            If ClientWidth < Tw then
              ClientWidth := Tw + 20;
            X.cbSize := Sizeof(TScrollInfo);
            X.fMask := SIF_Page or SIF_Pos OR SIF_Range;
            X.nPage  := 1;
            X.nMin := 0;
            X.nMax := Tw;
            X.nPos := 0;
            SetScrollInfo(Sg.Handle, sb_Horz, X, True);
            Sg.Visible := True;
            Sg.BringToFront;
            RefreshSYSMenu;
            LoadGrid;
          end;
        wm_FormView:
          begin
            ShowAllControls;
            Sg.Hide;
            Width := SavedWidth;
            RefreshSYSMenu;
          end;
      end;
  end;
end;

end.
