unit ActServ_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ ActServ Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_ActServ: TGUID = '{3EF70080-40B9-11D5-9128-00C00C702F1A}';

const

{ Component class GUIDs }
  Class_DataSvr: TGUID = '{3EF70082-40B9-11D5-9128-00C00C702F1A}';

type

{ Forward declarations: Interfaces }
  IDataSvr = interface;
  IDataSvrDisp = dispinterface;

{ Forward declarations: CoClasses }
  DataSvr = IDataSvr;

{ Dispatch interface for DataSvr Object }

  IDataSvr = interface(IDispatch)
    ['{3EF70081-40B9-11D5-9128-00C00C702F1A}']
    function Get_Animal(Index: Integer): WideString; safecall;
    procedure Set_Animal(Index: Integer; const Value: WideString); safecall;
    property Animal[Index: Integer]: WideString read Get_Animal write Set_Animal;
  end;

{ DispInterface declaration for Dual Interface IDataSvr }

  IDataSvrDisp = dispinterface
    ['{3EF70081-40B9-11D5-9128-00C00C702F1A}']
    property Animal[Index: Integer]: WideString dispid 1;
  end;

{ DataSvrObject }

  CoDataSvr = class
    class function Create: IDataSvr;
    class function CreateRemote(const MachineName: string): IDataSvr;
  end;



implementation

uses ComObj;

class function CoDataSvr.Create: IDataSvr;
begin
  Result := CreateComObject(Class_DataSvr) as IDataSvr;
end;

class function CoDataSvr.CreateRemote(const MachineName: string): IDataSvr;
begin
  Result := CreateRemoteComObject(MachineName, Class_DataSvr) as IDataSvr;
end;


end.
