unit TTreeViewExUnit;

{**********************************************************************}
{                                                                      }
{  TTreeViewEx                                                         }
{  Version 1.0                                                         }
{                                                                      }
{                                                                      }
{  Copyright 2002 Workshell Inc.                                      }
{                                                                      }
{**********************************************************************}
{                                                                      }
{  TTreeViewEx was created to get around the annoying fact that the    }
{  current Borland TTreeView implementation only saves a Tree Node's   }
{  caption nothing more.                                               }
{                                                                      }
{  TTreeViewEx will save both caption, image indexes and data - the    }
{  data part relies on an event so u can supply the size of the data.  }
{                                                                      }
{  This component is free for any use, just don't go ripping me off    }
{  calling this code your own! Credit where credits due...             }
{                                                                      }
{**********************************************************************}
{                                                                      }
{  Web:    http://www.workshell.co.uk/                                 }
{  E-Mail: treeview@workshell.co.uk                                    }
{                                                                      }
{**********************************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, ComCtrls;

type
 TRequestDataSizeEvent = procedure(Sender: TObject; Node: TTreeNode; var Size: Integer) of object;
 TNodeLoadedEvent = procedure(Sender: TObject; Node: TTreeNode) of object;

type
  TTreeViewEx = class(TTreeView)
  private
    { Private declarations }
    FOnRequestDataSize: TRequestDataSizeEvent;
    FOnNodeLoaded: TNodeLoadedEvent;

    procedure LoadNodes(Stream: TStream; Node: TTreeNode);
    procedure SaveNodes(Stream: TStream; Node: TTreeNode);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure LoadFromFileEx(const FileName: String);
    procedure SaveToFileEx(const FileName: String);
    procedure LoadFromStreamEx(Stream: TStream);
    procedure SaveToStreamEx(Stream: TStream);
  published
    { Published declarations }
    property OnRequestDataSize: TRequestDataSizeEvent read FOnRequestDataSize write FOnRequestDataSize;
    property OnNodeLoaded: TNodeLoadedEvent read FOnNodeLoaded write FOnNodeLoaded;
  end;

procedure Register;

implementation

function StreamReadString(Stream: TStream): String;
var
 Count, I: Integer;
 Buffer: String;
 C: Char;
begin
 if Stream = nil then
  begin
   Result := '';
   Exit;
  end;
 Stream.Read(Count,SizeOf(Integer));
 Buffer := '';
  for I := 1 to Count do
   begin
    Stream.Read(C,SizeOf(Char));
    Buffer := Buffer + C;
   end;
 Result := Buffer;
end;

procedure StreamWriteString(Stream: TStream; S: String);
var
 Count, I: Integer;
 C: Char;
begin
 if Stream = nil then Exit;
 Count := Length(S);
 Stream.Write(Count,SizeOf(Integer));
  for I := 1 to Count do
   begin
    C := S[I];
    Stream.Write(C,SizeOf(Char));
   end;
end;

{ TTreeViewEx }

procedure TTreeViewEx.LoadFromFileEx(const FileName: String);
var
 F: TFileStream;
begin
 F := TFileStream.Create(FileName,fmOpenRead or fmShareDenyWrite);
  try
   LoadFromStreamEx(F);
  finally
   F.Free;
  end;
end;

procedure TTreeViewEx.SaveToFileEx(const FileName: String);
var
 F: TFileStream;
begin
 F := TFileStream.Create(FileName,fmCreate or fmShareDenyWrite);
  try
   SaveToStreamEx(F);
  finally
   F.Free;
  end;
end;

procedure TTreeViewEx.LoadNodes(Stream: TStream; Node: TTreeNode);
var
 Name: String;
 Level, ImageIndex, StateIndex, SelectedIndex, DataSize, ChildCount, I: Integer;
 Data: Pointer;
 NewNode: TTreeNode;
begin
 Name := StreamReadString(Stream);
 Stream.Read(Level,SizeOf(Integer));
 Stream.Read(ImageIndex,SizeOf(Integer));
 Stream.Read(StateIndex,SizeOf(Integer));
 Stream.Read(SelectedIndex,SizeOf(Integer));
 Stream.Read(DataSize,SizeOf(Integer));
  if DataSize > 0 then
   begin
    GetMem(Data,DataSize);
    Stream.Read(Data^,DataSize);
   end
  else
   Data := nil;
 Stream.Read(ChildCount,SizeOf(Integer));
  if Level > 0 then
   NewNode := Self.Items.AddChild(Node,Name)
  else
   NewNode := Self.Items.Add(nil,Name);
 NewNode.ImageIndex := ImageIndex;
 NewNode.StateIndex := StateIndex;
 NewNode.SelectedIndex := SelectedIndex;
 NewNode.Data := Data;
  if Assigned(FOnNodeLoaded) then FOnNodeLoaded(Self,NewNode);
  for I := 1 to ChildCount do
   begin
    LoadNodes(Stream,NewNode);
   end;
end;

procedure TTreeViewEx.SaveNodes(Stream: TStream; Node: TTreeNode);
var
 Name: String;
 Level, ImageIndex, StateIndex, SelectedIndex, DataSize, ChildCount, I: Integer;
 NewNode: TTreeNode;
begin
 Name := Node.Text;
 StreamWriteString(Stream,Name);
 Level := Node.Level;
 Stream.Write(Level,SizeOf(Integer));
 ImageIndex := Node.ImageIndex;
 Stream.Write(ImageIndex,SizeOf(Integer));
 StateIndex := Node.StateIndex;
 Stream.Write(StateIndex,SizeOf(Integer));
 SelectedIndex := Node.SelectedIndex;
 Stream.Write(SelectedIndex,SizeOf(Integer));
  if Assigned(FOnRequestDataSize) then
   FOnRequestDataSize(Self,Node,DataSize)
  else
   DataSize := -1;
  if Node.Data = nil then DataSize := -1;
 Stream.Write(DataSize,SizeOf(Integer));
  if DataSize > 0 then Stream.Write(Node.Data^,DataSize);
 ChildCount := Node.Count;
 Stream.Write(ChildCount,SizeOf(Integer));

 NewNode := Node.GetFirstChild;
  if NewNode = nil then Exit;
 SaveNodes(Stream,NewNode);
  for I := 2 to ChildCount do
   begin
    NewNode := Node.GetNextChild(NewNode);
     if NewNode <> nil then SaveNodes(Stream,NewNode);
   end;
end;

procedure TTreeViewEx.LoadFromStreamEx(Stream: TStream);
var
 Count, I: Integer;
begin
 if Stream = nil then Exit;

 Self.Items.Clear;
 Stream.Read(Count,SizeOf(Integer));
  for I := 1 to Count do
   begin
    LoadNodes(Stream,nil);
   end;
end;

procedure TTreeViewEx.SaveToStreamEx(Stream: TStream);
var
 Count, I: Integer;
begin
 if Stream = nil then Exit;

 Count := 0;
  for I := 0 to Self.Items.Count - 1 do
   begin
    if Self.Items[I].Level = 0 then Inc(Count);
   end;
 Stream.Write(Count,SizeOf(Integer));
  for I := 0 to Self.Items.Count - 1 do
   begin
    if Self.Items[I].Level = 0 then SaveNodes(Stream,Self.Items[I]);
   end;
end;

procedure Register;
begin
  RegisterComponents('Workshell', [TTreeViewEx]);
end;

end.
