unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, TTreeViewExUnit;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    lEMail: TLabel;
    lAge: TLabel;
    TreeView: TTreeViewEx;
    procedure Button3Click(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure TreeViewRequestDataSize(Sender: TObject; Node: TTreeNode;
      var Size: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
 PInfo = ^TInfo;
 TInfo = record
  EMail: String[255];
  Age: Integer;
 end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button3Click(Sender: TObject);
var
 ParentNode, ChildNode: TTreeNode;
 Info: PInfo;
begin
 ParentNode := TreeView.Items.Add(nil,'Bill Gates');
 GetMem(Info,SizeOf(TInfo));
 Info^.EMail := 'bill.gates@microsoft.com';
 Info^.Age := 45;
 ParentNode.Data := Info;

 ChildNode := TreeView.Items.AddChild(ParentNode,'Mrs Gates');
 GetMem(Info,SizeOf(TInfo));
 Info^.EMail := 'mrs.gates@microsoft.com';
 Info^.Age := 43;
 ChildNode.Data := Info;

 ChildNode := TreeView.Items.AddChild(ChildNode,'Junior Gates');
 GetMem(Info,SizeOf(TInfo));
 Info^.EMail := 'junior@microsoft.com';
 Info^.Age := 8;
 ChildNode.Data := Info;

 ParentNode := TreeView.Items.Add(nil,'Fred Bloggs');
 GetMem(Info,SizeOf(TInfo));
 Info^.EMail := 'fred@bloggs.com';
 Info^.Age := 4;
 ParentNode.Data := Info;

 ParentNode := TreeView.Items.Add(nil,'John Doe');
 ParentNode.Data := nil;

 ChildNode := TreeView.Items.AddChild(ParentNode,'Jane Doe');
 GetMem(Info,SizeOf(TInfo));
 Info^.EMail := 'jane-doe@uknown.com';
 Info^.Age := 5;
 ChildNode.Data := Info;
end;

procedure TForm1.TreeViewChange(Sender: TObject; Node: TTreeNode);
var
 Info: PInfo;
begin
 if TreeView.Selected = nil then
  begin
   lEMail.Caption := '';
   lAge.Caption := '';
   Exit;
  end;
 if TreeView.Selected.Data = nil then
  begin
   lEMail.Caption := '';
   lAge.Caption := '';
   Exit;
  end;
 Info := TreeView.Selected.Data;
 lEMail.Caption := Info^.EMail;
 lAge.Caption := IntToStr(Info^.Age);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 TreeView.LoadFromFileEx('test.dat');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 TreeView.SaveToFileEx('test.dat');
end;

procedure TForm1.TreeViewRequestDataSize(Sender: TObject; Node: TTreeNode;
  var Size: Integer);
begin
 Size := SizeOf(TInfo);
end;

end.
